<?php

namespace App\DataTables;

use App\Models\EmailDraft;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class EmailsDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
       
        return datatables()
        ->eloquent($query)
        ->addColumn('action', function($row) {
            $email = "Event";
            return '<a data-toggle="modal" data-target="#deletePopup" data-url="'.route('emails.destroy',$row->id).'"  data-id="'.$row->id.'" data-user="'.$email.'"
                onclick="deletePopup(this)">
                <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                    <i class="fas fa-trash" aria-hidden="true"></i>
                </button>
            </a>';
        })->addColumn('Assign Team Member', function($row) {
            $email = "Event";
            return '<a href="'.route('event.add').'?id='.$row->id.'">
            <button class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Member">
                <i class="bx bxs-edit" aria-hidden="true"></i>Assign
            </button>
        </a>';
        })->addColumn('Assign Admin', function($row) {
            $email = "Event";
            return '<a href="'.route('event.assignadmin').'?id='.$row->id.'">
            <button class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Member">
                <i class="bx bxs-edit" aria-hidden="true"></i>Assign Admin
            </button>
        </a>';
        })->rawColumns(['action', 'Assign Team Member','Assign Admin']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Event $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Event $model)
    {
        return $model->fetchAllUsers();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('events-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [

            Column::make('event_name')->title('Event_Name'),
            Column::make('details')->title('Event_Details'),
            Column::make('city')->title('City'),
            Column::make('start_date')->title('Start_Date'),
            Column::make('end_date')->title('End_Date'),
            Column::make('Assign Team Member')->title('Assign_Team_Member'),
            Column::make('Assign Admin')->title('Assign_Team_Admin'),
            Column::computed('action')
                  ->exportable(false)
                  ->printable(false)
                  ->width(60)
                  ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Events_' . date('YmdHis');
    }
}



