<?php

namespace App\DataTables;

use App\Models\Event;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;
use Illuminate\Support\Facades\Auth;

class EventsDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function __construct()
    {
        $this->_authuser = Auth::user();
    }
    public function dataTable($query)
    {
        if($this->_authuser->type == "user"){
            return datatables()
                ->eloquent($query)
                ->addColumn('Client List', function($row) {
                    // Return the button HTML with or without count
                    return '<a href="'.route('visitor.listbyevent').'?event_id='.$row->id.'" target="_blank">
                                <button style="color:#fff;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Client List">
                                    <i class="bx bxs-edit" aria-hidden="true"></i>Client List
                                </button>
                            </a>';
                })->addColumn('add_client', function($row) {
                $event = "Event";
                return '<a href="'.route('visitor.add',['event_id'=>$row->id]).'">
                <button  style="color:#fff;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Admin">
                    <i class="bx bxs-edit" aria-hidden="true"></i>Add Client
                </button>
            </a>';
                })
                ->addColumn('visitor_count', function($row) {
                    $event_data = DB::table('visitors')->where('event_id',$row->id)->count();

                        if($event_data != 0){
                            $data = $event_data;
                        }else{
                            $data = "";
                        }

                    return $data;
                })
            ->rawColumns(['visitor_count','Client List','add_client']);
        }else{
            return datatables()
            ->eloquent($query)
            ->addColumn('action', function($row) {

                    $event = "Event";
                    $btn = '<a href="javascript:void(0);" class="assign-team-member" data-name="'.$row->event_name.'" data-id="' . $row->id . '">
                            <button style="color:#fff;margin-top: 5px;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Member">
                                <i class="bx bxs-edit" aria-hidden="true"></i>Assign
                            </button>
                        </a>';
                    $btn .= '<a href="'.route('visitor.add',['event_id'=>$row->id]).'">
                            <button  style="color:#fff;margin-top: 5px;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Admin">
                                <i class="bx bxs-edit" aria-hidden="true"></i>Add Client
                            </button>
                        </a>';
                    $btn .= '<a data-toggle="modal" data-target="#deletePopupevent" data-url="'.route('event.destroy',$row->id).'"  data-id="'.$row->id.'" data-user="'.$event.'"
                                onclick="deletePopupevent(this)">
                                <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete" style="margin-top: 5px;">
                                    <i class="fas fa-trash" aria-hidden="true"></i>
                                </button>
                            </a>';
                    $btn .= '<a href="'.route('event.edit').'?id='.$row->id.'"  >
                                <button class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="left" title="Edit" style="margin-top: 5px;">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>';
                    return $btn;

            })->addColumn('Assign Team Member', function($row) {
                return '<a href="javascript:void(0);" class="assign-team-member" data-name="'.$row->event_name.'" data-id="' . $row->id . '">
                            <button style="color:#fff;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Member">
                                <i class="bx bxs-edit" aria-hidden="true"></i>Assign
                            </button>
                        </a>';
            })->addColumn('Assign Admin', function($row) {
                $event = "Event";
                return '<a href="'.route('event.assignadmin').'?id='.$row->id.'">
                    <button  style="color:#fff;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Admin">
                        <i class="bx bxs-edit" aria-hidden="true"></i>Assign Admin
                    </button>
                </a>';
            })->addColumn('add_client', function($row) {
                $event = "Event";
                return '<a href="'.route('visitor.add',['event_id'=>$row->id]).'">
                    <button  style="color:#fff;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Admin">
                        <i class="bx bxs-edit" aria-hidden="true"></i>Add Client
                    </button>
                </a>';
            })->addColumn('visitor_count', function($row) {
                $event_data = DB::table('visitors')->where('event_id',$row->id)->count();

                    if($event_data != 0){
                        $data = $event_data;
                    }else{
                        $data = "";
                    }

                return $data;
            })
            ->addColumn('event_name', function($row) {

                    $event = "Event";
                    $btn = $row->event_name.' ';
                    $btn .= '<a href="javascript:void(0);" class="assign-team-member ml-4 mr-2" data-name="'.$row->event_name.'" data-id="' . $row->id . '" style="display: inline-block;">
                            <button style="color:#fff;margin-top: 5px;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Member">
                                <i class="bx bxs-edit" aria-hidden="true"></i>Assign
                            </button>
                        </a>';
                    $btn .= '<a href="'.route('visitor.add',['event_id'=>$row->id]).'" class="mr-2" style="display: inline-block;">
                            <button  style="color:#fff;margin-top: 5px;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Assign Team Admin">
                                <i class="bx bxs-edit" aria-hidden="true"></i>Add Client
                            </button>
                        </a>';
                    $btn .= '<a href="javascript:void(0);" data-toggle="modal" data-target="#deletePopupevent" data-url="'.route('event.destroy',$row->id).'"  data-id="'.$row->id.'" data-user="'.$event.'" onclick="deletePopupevent(this)" class="mr-2" style="text-decoration: none;">
                                <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete" style="margin-top: 5px;">
                                    <i class="fas fa-trash" aria-hidden="true"></i>
                                </button>
                            </a>';
                    $btn .= '<a href="'.route('event.edit').'?id='.$row->id.'"  target="_blank" class="mr-2" style="text-decoration: none;">
                                <button class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="left" title="Edit" style="margin-top: 5px;">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>';
                    return $btn;

            })
            ->rawColumns(['event_name','Assign Team Member','Assign Admin','edit','visitor_count','add_client']);
       }

    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Event $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Event $model)
    {
        $search = !empty(request('search')) ? request('search')['value'] :  "";

        return $model->fetchAllUsers($search);
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('events-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        if($this->_authuser->type == "user"){
            return [

            Column::make('event_name')->title('Event/Folder_Name')->searchable(false),
            // Column::computed('visitor_count')->title('Client Counts'),
            Column::make('details')->title('Event/Folder_Details')->searchable(false),
            Column::make('city')->title('City')->searchable(false),
            // Column::make('start_date')->title('Start_Date'),
            // Column::make('end_date')->title('End_Date'),
            Column::make('add_client')->title('Add Client')->searchable(false),
            Column::make('Client List')->title('Client List')->searchable(false),
        ];
        }else{
            return [

            Column::computed('event_name')->title('Event/Folder_Name')->searchable(false),
            // Column::computed('visitor_count')->title('Client Counts'),
            Column::make('details')->title('Event/Folder_Details')->searchable(false),
            Column::make('city')->title('City')->searchable(false),
            // Column::make('start_date')->title('Start_Date'),
            // Column::make('end_date')->title('End_Date'),
            // Column::make('Assign Team Member')->title('Assign_Team_Member'),
            // Column::make('Assign Admin')->title('Assign_Team_Admin'),
            // Column::make('add_client')->title('Add Client'),
            /*Column::computed('action')
                  ->exportable(false)
                  ->printable(false)
                //   ->width(60)
                  ->addClass('text-center'),*/
        ];
        }

    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Events_' . date('YmdHis');
    }
}



