<?php

namespace App\DataTables;

use App\Models\Expence;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class ExpenceAdminDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->filter(function ($query) {
                if ($keyword = $this->request->input('search.value')) {
                    return $query->where('users.CustomerName', 'LIKE', '%' . $keyword . '%')
                    ->orWhere('expence_type.name', 'LIKE', '%' . $keyword . '%')
                    ->orWhere('expence.amount', 'LIKE', '%' . $keyword . '%')
                    ->orWhere('expence.start_location', 'LIKE', '%' . $keyword . '%')
                    ->orWhere('expence.end_location', 'LIKE', '%' . $keyword . '%');
                }
                return $query;
            })
            ->editColumn('created_at', function ($row) {
                return $row->created_at->format('Y-m-d');
            })
            ->addColumn('action', function($row) {

                $viewUrl = route('expence.images',$row->id);
        //         $btn = '<button class="btn btn-primary btn-sm ajaxModelOpenBtn" data-url="'.$viewUrl.'">  <span class="submit-text"><i class="fas fa-images"></i></span>
        //   <div class="spinner-border text-light submit-loader" role="status" style="width:16px;height:16px;display:none;">
        //     <span class="visually-hidden"></span>
        //   </div></button>';
        $btn = "";
        $images = $row->expenceImages->pluck('image')->toArray();
        if(count($images) > 0){
            $btn = "<button class='btn btn-primary btn-sm expence-images-btn' data-expence-data='". htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') ."' data-images='". htmlspecialchars(json_encode($images), ENT_QUOTES, 'UTF-8') ."'> <i class='fas fa-images'></i></button>";
        }
                return $btn;
            })
            ->rawColumns(['action']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Category $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Expence $model)
    {
        return $model->fetchAllExpence($this->customer_id,$this->start_date,$this->end_date);
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('expence-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            Column::make('name')->title('Expense Type'),
            Column::computed('CustomerName')->title('Team Member'),
            Column::computed('amount')->title('Amount'),
            Column::computed('start_location')->title('Start Location'),
            Column::computed('end_location')->title('End Location'),
            Column::make('created_at')->title('Created At'),
            // Column::make('updated_at'),
            Column::computed('action')
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Category_' . date('YmdHis');
    }
}
