<?php

namespace App\DataTables;

use App\Models\Product;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;

class ProductsDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('name', function ($row) {
                $btn = '<div style="display: flex; align-items: center;">';
                $btn .= '<span style="margin-right: 10px;">' . $row->name . '</span>';
                $btn .= '<a href="javascript:void(0);" class="btn btn-sm btn-primary btn-' . $row->id . '" data-name="' . $row->name . '" data-product_code="' . $row->product_code . '" data-product_message="' . $row->product_message . '" data-hsn_code="' . $row->hsn_code . '" data-price="' . $row->price . '" data-technical_specification="' . $row->technical_specification . '" data-quotation_image="' . $row->quotation_image . '" data-gst="' . $row->gst . '" onclick="editname(' . $row->id . ');">';
                $btn .= '<i class="fa fa-pencil-alt"></i>';
                $btn .= '</a>';
                $btn .= '</div>';
                return $btn;
            })
            ->addColumn('image', function ($row) {
                return '<span id="viewButton">
                        <button class="btn btn-primary btn-sm" data-id="' . $row->id . '" onclick="showfilewithimage(this)">View</button>
                        </span>';
            })
            ->addColumn('product_code', function ($row) {
                return $row->product_code;
            })
            ->addColumn('product_qr', function ($row) {
                $html = '';
                if (!empty($row->product_code) && !empty($row->qr_file)) {
                    //fancybox a tag
                    $html .= '<a href="' . url('uploads/product_qr/' . $row->qr_file) . '" data-fancybox>';
                    $html .= '<img src="' . url('uploads/product_qr/' . $row->qr_file) . '" alt="Product QR" style="width: 50px; height: 50px;">';
                    $html .= '</a>';
                    return $html;
                } else {
                    return '';
                }
                return $html;
            })
            // ->addColumn('action', function($row) {
            //     $btn = '<a href="'.route('product.detail').'?id='.$row->id.'">
            //                 <button class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Detail" style="color: white;">
            //                     <i class="bx bxs-edit" aria-hidden="true"></i>Detail
            //                 </button>
            //             </a>';
            //     return $btn;
            // })
            ->addColumn('Visitor_Intrested_Product', function ($row) {
                $id = $row->id;
                $productcount = DB::table('visitor_products')
                    ->where('product_id', $id)
                    ->count();

                return '<a href="' . route('product.visitorproductcount') . '?id=' . $row->id . '">' . $productcount . '</a>';
            })->addColumn('delete', function ($row) {
                $product = "Product";
                return '<a data-toggle="modal" data-target="#deletePopup" data-url="' . route('product.destroy', $row->id) . '" data-user="' . $product . '" data-id="' . $row->id . '"
                        onclick="deletePopupProduct(this)">
                            <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                <i class="fas fa-trash" aria-hidden="true"></i>
                            </button>
                        </a>';
            })->rawColumns(['image', 'action', 'Visitor_Intrested_Product', 'delete', 'edit', 'name', 'product_code', 'product_qr']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Product $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Product $model)
    {
        return $model->fetchAllProduct();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->setTableId('products-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(1)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        $columns = [

            // Column::make('fk_user_id','users.user_id')->title('User Id'),
            Column::computed('name')->title('Name')
        ];
        if (session('productqr') == 1) {
            $columns[] = Column::computed('product_code')->title('Product Code');
        }
        $columns[] = Column::computed('image')->title('Product Image');
        if (session('productqr') == 1) {
            $columns[] = Column::computed('product_qr')->title('Product QR');
        }


        $columns[] = Column::computed('Visitor_Intrested_Product')->title('Client Interested Product');
        $columns[] = Column::computed('hsn_code')->title('HSN Code');
        $columns[] = Column::computed('price')->title('Price');
        // Column::computed('action')->title('Action'),
        $columns[] = Column::computed('delete')->title('Action');

        // Column::computed('action')
        // ->exportable(false)
        // ->printable(false)
        // ->width(60)
        // ->addClass('text-center'),

        return $columns;
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Products_' . date('YmdHis');
    }
}
