<?php

namespace App\DataTables;

use App\Models\Template;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;

class TemplatesDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('created_at', function($row) {
                return $row->created_at->format('d-m-Y h:i:s');
            })
            // ->editColumn('name', function($row) {
            //     return strtolower( str_replace( " ", "_", $row->name ) );
            // })
            ->editColumn('message', function($row) {
                $message = strlen($row->message) > 50 ? substr($row->message,0,50)."..." : $row->message;
                return $message;
            })
            ->editColumn('is_default', function($row) {
                if($row->is_default){
                    $checkbox = '<input type="checkbox" checked name="is_default" data-url="'.route('template.updateDefault',$row->id).'" onclick="updateDefaultStatus(this)">';
                }else{
                    $checkbox = '<input type="checkbox" name="is_default" data-url="'.route('template.updateDefault',$row->id).'" onclick="updateDefaultStatus(this)">';
                }
                return $checkbox;
            })
            ->addColumn('approval_status', function($row) {
                switch ($row->status) {
                    case 'NEW':
                    case 'PENDING':
                        $label = '<span style="color:grey">'.$row->status.'</span>';
                        break;
                    case 'APPROVED':
                        $label = '<span style="color:green">'.$row->status.'</span>';
                        break;
                    case 'REJECTED':
                        $label = '<span style="color:red">'.$row->status.'</span>';
                        break;
                }
                return $label;
            })
            ->addColumn('approval_button', function($row) {
                if($row->status == 'NEW' || $row->status == 'REJECTED' || $row->status == 'APPROVED' || $row->status == 'PENDING'){
                    if($row->approval_at){
                        $label = '<button disabled class="btn bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Send Approval" style="color: white;">
                                <i class="fa fa-paper-plane" aria-hidden="true"> Send Approval</i>
                            </button>';
                    }else{
                        $label = '<button class="btn bg-gradient-info btn-sm" onclick="sendApprovalFunction(this)" data-url="'.route('template.send-approval',$row->id).'" data-toggle="tooltip" data-placement="left" title="Send Approval" style="color: white;">
                                <i class="fa fa-paper-plane" aria-hidden="true"> Send Approval</i>
                            </button>';
                    }
                }
                return $label;
            })
            ->addColumn('send_test_message', function($row) {
                $label = '<button class="btn bg-gradient-info btn-sm" onclick="sendTestMessage(this)" data-url="'.route('template.send-test-message',$row->id).'" data-toggle="tooltip" data-placement="left" title="Send Approval" style="color: white;">
                            <i class="fa fa-paper-plane" aria-hidden="true"> Send Test Message</i>
                        </button>';
                return $label;
            })
            // ->addColumn('action', function($row) {
            //     $btn = '<a href="'.route('product.detail').'?id='.$row->id.'">
            //                 <button class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Detail" style="color: white;">
            //                     <i class="bx bxs-edit" aria-hidden="true"></i>Detail
            //                 </button>
            //             </a>';
            //     return $btn;
            // })
            // ->addColumn('Visitor_Intrested_Product', function($row) {
            //         $id=$row->id;
            //         $productcount =DB::table('visitor_products')
            //         ->where('product_id',$id)
            //         ->count();

            //     return '<a href="'.route('product.visitorproductcount').'?id='.$row->id.'">'.$productcount.'</a>';
            // })
            ->addColumn('action', function($row) {
               // $btn = '<a href="'.route('template.edit',$row->id).'" style="text-decoration: none;">
               //             <button class="btn bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Edit" style="color: white;">
               //                 <i class="fas fa-edit" aria-hidden="true"></i>
               //             </button>
               //         </a>';
                $name="Template";
                $btn = '<a data-toggle="modal" data-target="#deletePopup" data-url="'.route('template.destroy',$row->id).'" data-user="'.$name.'" data-id="'.$row->id.'"
                        onclick="deletePopup(this)">
                            <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                <i class="fas fa-trash" aria-hidden="true"></i>
                            </button>
                        </a>';
                return $btn;
            })->rawColumns(['image','action','name','is_default','approval_status','approval_button','send_test_message']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Template $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Template $model)
    {
        return $model->orderBy('id', 'desc');;
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('templates-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [

            // Column::make('fk_user_id','users.user_id')->title('User Id'),
            Column::computed('name')->title('Name'),
            Column::computed('message')->title('Message'),
            // Column::computed('file_url_new')->title('File URL New'),
            Column::computed('created_at')->title('Created Date'),
            Column::computed('approval_button')->title('Approval Button'),
            Column::computed('approval_status')->title('Approval Status'),
            Column::computed('is_default')->title('Is Default'),
            Column::computed('send_test_message')->title('Send Test Message'),
            Column::computed('action')->title('Action'),

            // Column::computed('action')
            // ->exportable(false)
            // ->printable(false)
            // ->width(60)
            // ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Templates_' . date('YmdHis');
    }
}
