<?php

namespace App\Events;

// use Illuminate\Broadcasting\InteractsWithSockets;
// use Illuminate\Foundation\Events\Dispatchable;
// use Illuminate\Queue\SerializesModels;
// use Illuminate\Notifications\Notifiable;

// class AutomaticNotificationEvent
// {
//     use Dispatchable, InteractsWithSockets, SerializesModels;

//     public $message;

//     public function __construct($message)
//     {
//         $this->message = $message;
//     }
// }
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class AutomaticNotificationEvent implements ShouldBroadcast
{
    use SerializesModels;

    public $userId;

    /**
     * Create a new event instance.
     *
     * @param int $userId The ID of the user who has been assigned.
     * @return void
     */
    public function __construct($userId)
    {
        $this->userId = $userId;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\PrivateChannel
     */
    public function broadcastOn()
    {
        return new PrivateChannel('user.' . $this->userId);
    }

    /**
     * Get the data to broadcast.
     *
     * @return array
     */
    public function broadcastWith()
    {
        return [
            'message' => 'You have been assigned to a new event.',
            // You can include any additional data you want to send with the notification
        ];
    }
}