<?php
namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
class ClientCompanyExport implements FromCollection, WithHeadings, WithEvents
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $companyName = urldecode($this->request->company_name);
        $companyDomain = strtolower(str_replace(' ', '', $companyName)) . '.com';
        return DB::table('visit_data')
            ->join('visitors', 'visitors.id', '=', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', '=', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', '=', 'visitors.customer_id')
            // ->whereRaw('LOWER(visitors.company_name) = ?', [strtolower($companyName)])
            ->where(function ($q) use ($companyName, $companyDomain) {
                $q->whereRaw('LOWER(visitors.company_name) = ?', [strtolower($companyName)])
                    ->orWhereRaw('LOWER(visitors.email) LIKE ?', ['%@' . $companyDomain]);
            })
            ->select(
                'visitors.name as Client Name',
                'events.event_name as Event/Folder_Name',
                'users.CustomerName as Team Member',
                'visitors.mobile_no as Mobile',
                'visitors.email as Email',
                'visit_data.visit_time as Visited Date',
                'visit_data.action',
                'visit_data.remarks'
            )
            ->get();
    }

    public function headings(): array
    {
        return [
            'Client Name',
            'Event/Folder_Name',
            'Team Member',
            'Mobile',
            'Email',
            'Visited Date',
            'Visit Action',
            'Remarks',
        ];
    }

    public function registerEvents(): array
    {
        $companyName = urldecode($this->request->company_name);

        return [
            AfterSheet::class => function (AfterSheet $event) use ($companyName) {
                $event->sheet->insertNewRowBefore(1, 1);
                $event->sheet->setCellValue('A1', 'Company Name: ' . $companyName);
                $event->sheet->mergeCells('A1:H1');

                $event->sheet->getStyle('A1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'size' => 12,
                    ],
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                ]);
            },
        ];
    }
}
