<?php

namespace App\Helpers;

use App\Models\Visitor;
use App\Models\AssignDivisionAdmin;
use App\Models\AssignDivisionTeamMember;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

use Illuminate\Support\Facades\Auth;

class Helper
{
    /**
     * Get the count of visitors for the current user.
     *
     * @return int
     */
    public static function getVisitorCountToday()
    {

        DB::enableQueryLog();

        $user_id = Auth::user()->user_id;
        $userdetail = Auth::user()->getUser();
        $currentUserCustomerId = $userdetail->CustomerID;

        // Base query for Visitor model
        $query = Visitor::query();

        $query->where(function ($query) use ($user_id, $currentUserCustomerId) {
            $query->whereIn('event_id', function ($innerQuery) use ($user_id) {
                $innerQuery->select('fk_event_id')
                    ->from('event_assignments')
                    ->where('fk_user_id', $user_id);
            })
                ->where(function ($subQuery) use ($user_id, $currentUserCustomerId) {
                    $subQuery->whereIn('event_id', function ($innerSubQuery) use ($user_id) {
                        $innerSubQuery->select('fk_event_id')
                            ->from('event_assignments')
                            ->where('fk_user_id', $user_id)
                            ->where('is_admin', 'true');
                    })
                        ->orWhere(function ($subSubQuery) use ($currentUserCustomerId) {
                            $subSubQuery->where('customer_id', $currentUserCustomerId);
                        });
                });
        });

        $now = date('Y-m-d');
        $query->whereDate('follow_up_time', $now);
        $result =  $query->orderBy('id', 'desc')->groupBy('id')->get();
        return count($result);
    }
    public static function getVisitorCountPast()
    {

        DB::enableQueryLog();

        $user_id = Auth::user()->user_id;
        $userdetail = Auth::user()->getUser();
        $currentUserCustomerId = $userdetail->CustomerID;

        // Base query for Visitor model
        $query = Visitor::query();

        $query->where(function ($query) use ($user_id, $currentUserCustomerId) {
            $query->whereIn('event_id', function ($innerQuery) use ($user_id) {
                $innerQuery->select('fk_event_id')
                    ->from('event_assignments')
                    ->where('fk_user_id', $user_id);
            })
                ->where(function ($subQuery) use ($user_id, $currentUserCustomerId) {
                    $subQuery->whereIn('event_id', function ($innerSubQuery) use ($user_id) {
                        $innerSubQuery->select('fk_event_id')
                            ->from('event_assignments')
                            ->where('fk_user_id', $user_id)
                            ->where('is_admin', 'true');
                    })
                        ->orWhere(function ($subSubQuery) use ($currentUserCustomerId) {
                            $subSubQuery->where('customer_id', $currentUserCustomerId);
                        });
                });
        });

        $now = date('Y-m-d H:i:s');
        $query->whereDate('follow_up_time', '<', $now)
            ->whereDate('visitors.follow_up_time', '!=', '00:00:00');
        $result =  $query->orderBy('id', 'desc')->groupBy('id')->get();
        return count($result);
    }


    public static function sendTemplateMessage(
        $config,
        $template,
        string $toMobileNo,
        array $variables = [],
        string $templateLanguage = 'en',
        ?string $customMessageString = null,
        ?string $employeeName = null
    ): array {

        // WhatsApp Business Account number ID
        $whatsappBusinessId = $config?->phone_id;
        $fbToken = $config?->token;
        $templateName = $template?->name;

        $url = "https://graph.facebook.com/v21.0/{$whatsappBusinessId}/messages";

        // Prepare template components (variables)
        $components = [];
        if (!empty($variables)) {
            $components[] = [
                'type' => 'body',
                'parameters' => collect($variables)->map(fn($v) => [
                    'type' => 'text',
                    'text' => $v,
                ])->toArray(),
            ];
        }

        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => $toMobileNo,
            'type' => 'template',
            'template' => [
                'name' => $templateName,
                'language' => ['code' => $templateLanguage],
                'components' => $components,
            ],
        ];

        $response = Http::withToken($fbToken)->post($url, $payload);

        if ($response->failed()) {
            return [
                'success' => false,
                'status' => $response->status(),
                'error' => $response->json() ?? $response->body(),
            ];
        }

        return [
            'success' => true,
            'status' => $response->status(),
            'data' => $response->json(),
        ];
    }
}
