<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\UserAttendanceDataTable;
use App\Models\Category;
use App\Models\Sub_category;
use DB;
use Alert;
use Carbon\Carbon;
use App\Models\User;
use App\Exports\UserAttendanceExport;
use PDF;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\UserAttendance;

class AttendanceController extends Controller
{
    public function index(Request $request, UserAttendanceDataTable $dataTable)
    {        
        $teammember_id = 'all';
        $month = 'all';
        $year = 'all';
        if(isset($request->teammember_id)){
            $teammember_id = $request->teammember_id;
        }
        if(isset($request->month)){
            $month = $request->month;
        }else{
            $month = date('m');
        }
        if(isset($request->year)){
            $year = $request->year;
        }else{
            $year = date('Y');
        }
        $userdata = User::orderBy('CustomerName', 'asc')->get();
        $attendance = '';
        if($teammember_id != 'all'){
            $attendance = DB::table('user_attendances')
            ->select(
                'customer_id',
                DB::raw("DATE_FORMAT(check_in_time, '%Y-%m') as month_year"),
                DB::raw('MIN(check_in_time) as first_check_in'),
                DB::raw('MAX(check_out_time) as last_check_out'),
                DB::raw('COUNT(DISTINCT DATE(check_in_time)) as total_days_present')
            )
            ->where('customer_id', $teammember_id)
            ->whereYear('check_in_time', $year)
            ->whereMonth('check_in_time', $month)
            ->groupBy('customer_id', DB::raw("DATE_FORMAT(check_in_time, '%Y-%m')"))
            ->orderBy('customer_id')
            ->orderBy('month_year')
            ->first();
        }
        return $dataTable->with([
            'teammember_id' => $teammember_id,
            'month' => $month,
            'year' => $year
        ])->render('user_attendances.index',compact('userdata','teammember_id','month','year','attendance'));
    }

    public function exportuserattendance(Request $request)
    { 
        $teammember_id = 'all';
        $month = 'all';
        $year = 'all';
        if(isset($request->teammember_id)){
            $teammember_id = $request->teammember_id;
        }
        if(isset($request->month)){
            $month = $request->month;
        }
        if(isset($request->year)){
            $year = $request->year;
        }
        $date = 'UserAttendance '.date('Y-m-d H:i:s');
        return Excel::download(new UserAttendanceExport($teammember_id, $month, $year), $date.'.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    public function liveuserattendance(Request $request)
    {

        return view('user_attendances/livelocation');
    }
    public function fetchAllEmployees(Request $request)
    {
        $date = $request->date;
        $employees = UserAttendance::select('user_attendances.*','users.CustomerName')
        ->leftJoin('users', 'user_attendances.customer_id', '=', 'users.CustomerID')
        ->whereDate('user_attendances.check_in_time',$date)
        ->groupBy('user_attendances.customer_id')->orderBy('users.CustomerName', 'asc')->get();

        //dd($employees); 
        return response()->json(['data' => $employees]);
    }
    public function fetchLastRecordOfAllEmployees(Request $request)
    {
        $customer_id = $request->customer_id;
        $date = $request->date;

        $employees = UserAttendance::select('user_attendances.*','users.CustomerName')
        ->leftJoin('users', 'user_attendances.customer_id', '=', 'users.CustomerID')
        ->where('user_attendances.customer_id',$customer_id)
        ->whereDate('user_attendances.check_in_time',$date)
        ->get()->first();
        

        //dd($employees); 
        return response()->json(['data' => $employees]);
    }
    public function getEmployeeLocations(Request $request)
    {
        $customer_id = $request->customer_id;
        $date = $request->date;

        $employees = UserAttendance::select('user_attendances.*','users.CustomerName')
        ->leftJoin('users', 'user_attendances.customer_id', '=', 'users.CustomerID')
        ->where('user_attendances.customer_id',$customer_id)
        ->whereDate('user_attendances.check_in_time',$date)
        ->get();
        

        //dd($employees); 
        return response()->json(['data' => $employees]);
    }
    
    
}