<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\Admin;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DB;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255'],
            'phone' => ['required'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    public function register(Request $request)
    {
        dd($request->all());
        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        $this->guard()->login($user);

        if ($response = $this->registered($request, $user)) {
            return $response;
        }

        return $request->wantsJson()
            ? new JsonResponse([], 201)
            : redirect($this->redirectPath());
    }

    public function getOtp(Request $request)
    {
        //dd($request->all());
        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/sendOtp';
        $data = [
            // "CustomerID" => 0,
            'email' => $request->email,
            'mobile' => $request->mobile,
            'type' => 'register'
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $getOtpResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $getOtpResponse = json_decode($getOtpResponse);
        // dd($getOtpResponse->status);

        // return response()->json([
        //     "status" => true,
        //     "message" => 'OTP Received',
        //     // "data" => base64_encode('789456'),
        // ]);

        if ($getOtpResponse) {
            if (!$getOtpResponse->status) {
                return response()->json([
                    "status" => false,
                    "message" => $getOtpResponse->msg,
                ]);
            } else {
                return response()->json([
                    "status" => true,
                    "message" => $getOtpResponse->msg,
                    "data" => base64_encode($getOtpResponse->data->otp),
                    // "data" => base64_encode('789456'),
                ]);
            }
        } else {
            return response()->json([
                "status" => false,
                "message" => 'Api failed!',
            ]);
        }
    }

    public function userCreate(Request $request)
    {
        // dd($request->all());

        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/customerdetail';
        $data = [
            'CustomerID' => 0,
            'device_type' => 'web',
            "android_version" => "android_version",
            "appversion" => "appversion",
            "device_model" => "device_model",
            "token" => "token",
            "imei" => "imei",
            'customer_name' => $request->name,
            'email' => $request->email,
            'mobile' => $request->phone,
            'type' => 'register'
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $registerCustomerResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $registerCustomerResponse = json_decode($registerCustomerResponse);
        // dd($registerCustomerResponse->status);

        if ($registerCustomerResponse) {
            if (!$registerCustomerResponse->status) {
                return response()->json([
                    "status" => false,
                    "message" => $registerCustomerResponse->msg
                ]);
            } else {
                $adminCount = Admin::count();
                // dd($adminCount);
                $isAdmin = 'false';
                $type = 'user';

                if ($adminCount == 0) {
                    $isAdmin = 'true';
                    $type = 'admin';
                }

                $userData = [
                    'CustomerID' => $registerCustomerResponse->CustomerID,
                    'CustomerName' => $request->name,
                    'Email' => $request->email,
                    'Phone' => $request->phone,
                    'is_admin' => $isAdmin,
                    'password' => Hash::make($request->password),
                ];

                $user_id = DB::table('users')->insertGetId($userData);

                DB::table('permissions')->updateOrInsert(
                    ['fk_customer_id' => $registerCustomerResponse->CustomerID], // Condition
                    [
                        'Contact_Share'  => '1',
                        'Call_Contact'   => '1',
                        'Send_Whatsapp'  => '1',
                        'Save_Contact'   => '1',
                        'Export_Excel'   => '1',
                        'Bulk_Whatsapp'  => '1',
                        'send_email'     => '0',
                        'updated_at'     => now(),
                        'created_at'     => now(), // Will only be used if inserting
                    ]
                );
                $admin = Admin::create([
                    'user_id' => $user_id,
                    'name' => $request->name,
                    'email' => $request->email,
                    'type' => $type,
                    'password' => Hash::make($request->password),
                ]);

                $this->guard()->login($admin);

                return response()->json([
                    "status" => true,
                    "message" => "User Registered Successfully",
                    "redirectPath" => env('APP_URL') . '/dashboard'
                ]);
            }
        }
    }
}
