<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use App\Models\User;
use App\Models\Admin;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DB;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    public function getOtp(Request $request)
    {
        //dd($request->all());
        // return response()->json([
        //     "status" => true,
        //     "message" => 'Test',
        // ]);
        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/sendOtp';
        $data = [
            'mobile' => $request->mobile,
            'type' => 'reset'
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $getOtpResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $getOtpResponse = json_decode($getOtpResponse);
        // dd($getOtpResponse->status);

        if($getOtpResponse){
            if(!$getOtpResponse->status){
                return response()->json([
                    "status" => false,
                    "message" => $getOtpResponse->msg,
                ]);
            }else{
                return response()->json([
                    "status" => true,
                    "message" => $getOtpResponse->msg,
                ]);
            }
        }else{
            return response()->json([
                "status" => false,
                "message" => 'Api failed!',
            ]);
        }
    }

    public function newCreate(Request $request)
    {
        // dd($request->all());

        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/verifyOtp';
        $data = [
            'mobile' => $request->phone,
            'otp' => $request->otp,
            'password' => $request->new_password
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $registerCustomerResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $registerCustomerResponse = json_decode($registerCustomerResponse);
        // dd($registerCustomerResponse);

        if($registerCustomerResponse){
            if(!$registerCustomerResponse->status){
                return response()->json([
                    "status" => false,
                    "message" => $registerCustomerResponse->msg
                ]);
            }else{
                // check for DB entry and login user.

                $user = User::where('CustomerID', $registerCustomerResponse->CustomerID)
                                ->first();

                if($user){
                    User::where('CustomerID',$user->CustomerID)->update([
                        'password' => Hash::make($request->new_password),
                    ]);

                    $admin = Admin::where('user_id',$user->user_id)->first();

                    if ($admin) {
                        $admin->update([
                            'password' => Hash::make($request->new_password),
                        ]);

                        $this->guard()->login($admin);
                    }

                    return response()->json([
                        "status" => true,
                        "message" => "User Password Reset Successfully",
                        "redirectPath" => route('dashboard')
                    ]);
                }

                return response()->json([
                    "status" => false,
                    "message" => "User Not found!"
                ]);
            }
        }
    }
}
