<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\CategoryDataTable;
use App\Models\Category;
use App\Models\Sub_category;
use DB;
use Alert;
use Carbon\Carbon;

class CategoryController extends Controller
{
    public function index(Request $request, CategoryDataTable $dataTable)
    {
        $categories = Category::pluck('name', 'id')->toArray();
        return $dataTable->with([
            'category_id' => $request->category_id,
        ])->render('category.index', compact('categories'));
    }
    public function addView(Request $request)
    {
        if (isset($request->id)) {
            $data['category'] = Category::where('id', $request->id)->first();
        } else {
            $data['category'] = '';
        }
        $html = view('category.editModal',$data)->render();
        return response()->json([
            "status" => true,
            "html" => $html,
        ]);
        // return view('category.add', $data);
    }

    public function store(Request $request)
    {
        // dd($request->all());
        if ($request->action == 'insert') {
        
            foreach ($request->name as $name) {
                if(!empty($name)){
                    $obj = new Category();
                    $obj->name = $name;
                    $obj->created_at = date('Y-m-d H:i:s');
                    $obj->save();
                }               
            }
            return response()->json([
                "status" => true,
                "message" => "You have successfully submitted data."
            ]);            
            // Alert::success('Congrats', 'You have successfully submitted the data.');
            // return redirect('category/list');
        } else {
            // Update a single record for the edit action
            $obj = Category::find($request->id);
            
            if ($obj) {
                $obj->name = $request->name; 
                $obj->updated_at =  date('Y-m-d H:i:s');
                $obj->save();
                return response()->json([
                    "status" => true,
                    "message" => "You have successfully updated data."
                ]);                
                // Alert::success('Congrats', 'Category has been updated successfully.');
                // return redirect('category/list');
            } else {
                return response()->json([
                    "status" => false,
                    "message" => "Category not found."
                ]);
                // Alert::error('Error', 'Category not found.');
                // return redirect('category/list');
            }
        }
    }

    public function destroy($id)
    {
        try {
            Category::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public function viewSubCategory(Request $request)
    {
        $data['category_id'] = $request->id;
        $data['subcategories'] = [];
        if (isset($request->id)) {
            $data['subcategories'] = Sub_category::where('fk_category_id', $request->id)->get();
        } 
        $html = view('category.subCategoryModal',$data)->render();
        return response()->json([
            "status" => true,
            "html" => $html,
        ]);
    }

    public function saveSubCategory(Request $request)
    {
        $status = false;
        $message = "Please add subcategory name.";
        if($request->has('existingNames')){
            foreach($request->existingNames as $key => $name){
                $obj = Sub_category::find($key);
                if ($obj) {
                    $obj->name = $name ?? $obj->name; // Update name if provided
                    $obj->updated_at = date('Y-m-d H:i:s');
                    $obj->save();
                }
            }
            $status = true;
            $message = "You have successfully saved subcategories";
        }

        if($request->has('name')){
            if(count(array_filter($request->name)) > 0){
                foreach ($request->name as $name) {
                    if(!empty($name)){
                        $obj = new Sub_category();
                        $obj->name = $name;
                        $obj->fk_category_id = $request->category_id;
                        $obj->created_at = date('Y-m-d H:i:s');
                        $obj->save();
                    }                  
                }
                $status = true;
                $message = "You have successfully saved subcategories";
            }
        }

        $data['category_id'] = $request->category_id;
        $data['subcategories'] = Sub_category::where('fk_category_id', $request->category_id)->get();
        $html = view('category.subCategoryModal',$data)->render();
        return response()->json([
            "status" => $status,
            "message" => $message,
            "html" => $html,
        ]);

    }
}
