<?php

namespace App\Http\Controllers;
use Alert;
use Illuminate\Http\Request;
use App\DataTables\EventsDataTable;
use App\DataTables\EventUsersDataTable;
use App\Models\Event;
use App\Models\EventUser;
use App\Models\Sendpush;
use DB;
use Carbon\Carbon;
use App\Models\Visitor;
use App\Models\User;
use Log;
use Illuminate\Support\Facades\Notification;
use App\Events\AutomaticNotificationEvent;
use App\Jobs\SendNotification;
use App\Models\EventImage;
use App\Models\EventMetaForms;
use App\Models\IntegrationConfig;

class EventController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_event = new Event();
        $this->_eventuser = new EventUser();
    }
    public function index(Request $request,EventsDataTable $dataTable)
    {

        return $dataTable->render('events.index');

    }
    public function addView(Request $request,EventUsersDataTable $dataTable)
    {
        $eventid=$request->id;
        $eventname =DB::table('events')->where('id',$eventid)->first();

        $assignedUsers = DB::table('event_assignments')
            ->select('users.user_id', 'event_assignments.*')
            ->leftJoin('users', 'users.user_id', '=', 'event_assignments.fk_user_id')
            ->where('event_assignments.fk_event_id', $eventid)
            ->get();  // Get all data, including user details

        $assignedUsers = $assignedUsers->keyBy('user_id');


        $assignedUserIds = $assignedUsers->pluck('user_id')->toArray();

        $users =  EventUser::where('users.is_delete','=','false')->orderBy('CustomerID', 'desc')->get();
        //dd($users);
        return view('events.eventlist_new',compact('eventid','eventname','users','assignedUsers','assignedUserIds'));

        //return $dataTable->with(['eventid' => $eventid])->render('events.eventlist',compact('eventid','eventname'));

    }
    public function store(Request $request,EventUsersDataTable $dataTable)
    {
        $id = $request->id;
        DB::table('event_assignments')->where('fk_event_id',$id)->delete();

        if(isset($request->customerids)){
            foreach($request->customerids as $key =>$user_id)
            {
                $query = DB::table('event_assignments')
                ->where('fk_user_id',$user_id)
                ->where('fk_event_id',$id)
                ->count();
                if($query == 0)
                {

                 $data =  [
                     'fk_user_id' => $user_id,
                     'fk_event_id' => $id,
                 ];

                 $insert =DB::table('event_assignments')->insert($data);
                }
             }
        }
        return redirect('event/list');
    }
    public function destroy($id)
    {
        try {
            Visitor::where('event_id',$id)->delete();
            DB::table('event_assignments')->where('fk_event_id',$id)->delete();
            Event::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
    public function addevent()
    {
        $now = Carbon::now()->format('Y-m-d');
        $integrationConfigCount = IntegrationConfig::where('key','facebook')->count();
        return view('events/addevent',compact('now','integrationConfigCount'));
    }
    public function addeventstore(Request $request)
    {
        // return $request->all();
        $data = [
            'event_name' => $request->eventname,
            'city' => $request->city,
            'details' => $request->details,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'type_show_all' => isset($request->type_show_all) ? $request->type_show_all : 'false',
            'created_at' => date('Y-m-d H:i:s'),
        ];
        $insert_id =DB::table('events')->insertGetId($data);
        $get_user = DB::table('users')->where('is_admin','=','true')->get();
        if(!empty($request->metaForms)){
        EventMetaForms::addMetaForms($insert_id, $request?->metaForms ?? []);
        }
        foreach($get_user as $one_user){
            $detail = ([
                'fk_user_id' => $one_user->user_id,
                'fk_event_id' => $insert_id,
                'is_admin' => 'true',
                'created_date' => date('Y-m-d H:i:s'),
            ]);
            DB::table('event_assignments')->insert($detail);
        }
        Alert::success('Congrats', 'You\'ve Successfully Data Inserted');
        return redirect('event/list');
    }
    public function editView(Request $request)
    {
        $get_data =DB::table('events')->where('id',$request->id)->first();
        $meta_forms = EventMetaForms::where('event_id',$request->id)->get();
        $now = Carbon::now()->format('Y-m-d');
        $integrationConfigCount = IntegrationConfig::where('key','facebook')->count();
        return view('events/editevent',compact('now','get_data','meta_forms','integrationConfigCount'));
    }
    public function editeventstore(Request $request)
    {

        $data = [
            'event_name' => $request->eventname,
            'city' => $request->city,
            'details' => $request->details,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'type_show_all' => $request->type_show_all,
            'updated_at' =>  date('Y-m-d H:i:s'),
        ];
        $update =DB::table('events')->where('id',$request->id)->update($data);
        Alert::success('Congrats', 'You\'ve Successfully Data Update');

        if(!empty($request->metaForms)){
            EventMetaForms::addMetaForms($request?->id, $request?->metaForms ?? []);
        }
        return redirect('event/list');
    }
    public function assignadminview(Request $request)
    {
        $id=$request->id;
        $data =DB::table('event_assignments')
        ->select('users.CustomerID','users.CustomerName','event_assignments.*')
        ->leftjoin('users', 'users.user_id', 'event_assignments.fk_user_id')
        ->where('event_assignments.fk_event_id', $id)
        ->where('users.user_id','!=',null)
        ->get();

        return view('events.eventassignadmin',compact('data'));
    }

    public function getEventModalHtml($eventid){
        $eventname =DB::table('events')->where('id',$eventid)->first();

        $assignedUsers = DB::table('event_assignments')
            ->select('users.user_id', 'event_assignments.*')
            ->leftJoin('users', 'users.user_id', '=', 'event_assignments.fk_user_id')
            ->where('event_assignments.fk_event_id', $eventid)
            ->get();  // Get all data, including user details

        $assignedUsers = $assignedUsers->keyBy('user_id');


        $assignedUserIds = $assignedUsers->pluck('user_id')->toArray();

        $users =  EventUser::where('users.is_delete','=','false')->orderBy('CustomerID', 'desc')->get();
        //dd($users);
        return view('events.eventlist_new',compact('eventid','eventname','users','assignedUsers','assignedUserIds'))->render();
    }

    public function storeadminassign(Request $request)
    {

        if ($request->isadminvalue == 'true') {
            $isadmin = 'false';
        } else {
            $isadmin = 'true';
        }

        $existingRecord = DB::table('event_assignments')
                            ->where('fk_user_id', $request->id)
                            ->where('fk_event_id', $request->event_id)
                            ->first();

        if ($existingRecord) {
            $data = [
                'is_admin' => $isadmin,
            ];
            DB::table('event_assignments')
                ->where('fk_user_id', $request->id)
                ->where('fk_event_id', $request->event_id)
                ->update($data);

        } else {
            DB::table('event_assignments')->insert([
                'fk_user_id' => $request->id,
                'fk_event_id' => $request->event_id,
                'is_admin' => 'true',
            ]);
            $isadmin = 'true';


        }
        $html = $this->getEventModalHtml($request->event_id);

        if($isadmin == 'true'){
            return response()->json([
                'message'=>'event assigned',
                'id'=>$request->id,
                'is_admin'=>$isadmin,
                'html'=>$html,
                'status'=>true,
            ],200);
        }
        else{
            return response()->json([
                'message'=>'event removed',
                'id'=>$request->id,
                'is_admin'=>$isadmin,
                'html'=>$html,
                'status'=>true,
            ],200);
        }

    }

    public function assignUser(Request $request)
    {
        if($request->operation == 'add')
        {
            DB::table('event_assignments')->insert([
                'fk_user_id' => $request->user_id,
                'fk_event_id' => $request->event_id,
            ]);

            $id = $request->user_id;
            $type = "eventassign";
            // SendNotification::dispatch($id,$type);
            return response()->json([
                'message'=>'event assigned',
                'id'=>$request->user_id,
                'is_assign'=>"true",
                "html"=>$this->getEventModalHtml($request->event_id),
                'status'=>true,
            ],200);

        }
        else if($request->operation == 'remove')
        {
            $assignedUser = DB::table('event_assignments')
                ->where('fk_user_id',$request->user_id)
                ->where('fk_event_id',$request->event_id)->first();
            if($assignedUser){
                // $assignedUser->delete();
                DB::table('event_assignments')
                ->where('fk_user_id',$request->user_id)
                ->where('fk_event_id',$request->event_id)->delete();
            }
            return response()->json([
                'message'=>'event removed',
                'id'=>$request->user_id,
                'is_assign'=>"false",
                "html"=>$this->getEventModalHtml($request->event_id),
                'status'=>true,
            ],200);

        }
        // return redirect()->back();

    }



    public function EventImageDelete(Request $request)
    {
        $eventimageId =  $request->eventimageId;
        // Find the event image by its ID
        $event_image = EventImage::where('id', $eventimageId)->first();

        // Check if the event image exists
        if ($event_image && $event_image->event_image) {
            // Extract the image name from the URL
            $imageName = basename(parse_url($event_image->event_image, PHP_URL_PATH));

            // Generate the full image path
            $imagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/' . $imageName);

            // Check if the file exists and delete it
            if (file_exists($imagePath)) {
                unlink($imagePath); // Delete the image file
            }

            // Delete the record from the database
            $event_image->delete();

            // Return success response
            return response()->json(['success' => 'Event image deleted successfully!']);
        } else {
            // If the image doesn't exist, return an error response
            return response()->json(['error' => 'Event image not found!'], 404);
        }
    }


}
