<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Visitor;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Product;
use App\Models\QuotationList;
use App\Models\QuotationConfiguration;
use PDF;
use App\DataTables\QuotationsDataTable;
use App\Models\AssignDivisionAdmin;
use App\Models\AssignDivisionTeamMember;
use Alert;

class NewQuotationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request, QuotationsDataTable $dataTable)
    {
        $data = [];
        $data['start_date'] = Carbon::now()->subDays(30)->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');

        $data['users'] = DB::table('users');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $data['users'] = $data['users']->select('CustomerName', 'CustomerID', 'is_delete')->orderBy('CustomerName', 'asc')->get();
        $data['CustomerID'] = "all";

        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }
        if (isset($request->CustomerID)) {
            $data['CustomerID'] = $request->CustomerID;
        }

        if($data['CustomerID'] != "all"){
                $startDateFormatted = date('Y-m-d', strtotime($data['start_date']));
                $endDateFormatted = date('Y-m-d', strtotime($data['end_date']));

                $query = QuotationList::where('userid', $data['CustomerID']);

                $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                    $query->whereDate('created_at', '>=', $startDateFormatted)
                        ->whereDate('created_at', '<=', $endDateFormatted);
                });

            $data['quotation_total'] = $query->sum('amount');
        }else{
            $data['quotation_total'] = "";
        }


        return $dataTable->with([
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'CustomerID' => $data['CustomerID']
        ])->render('newquotation.index', $data);
    }
    public function destroy($id)
    {
        try {
            $obj = QuotationList::find($id);
            $pdffile = public_path('uploads/quotation').'/' . $obj->pdffile;

            // Check if the file exists and delete it
            if (file_exists($pdffile)) {
                unlink($pdffile); // Delete the old back image
            }
            $obj->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public function admingenerateQuotation(Request $request)
    {
        $visitorList = Visitor::orderBy('company_name', 'ASC')->get();
        $userobj = auth()->user();
        $userdata =DB::table('users')->where('user_id',$userobj->user_id)->first();
        $machinList = Product::orderBy('name', 'asc')->get();
        $quotationconfig = QuotationConfiguration::first();
        return view('newquotation.adminquotationadd',compact('visitorList','userdata','machinList','quotationconfig'));
    }
    public function saveadmingenerateQuotation(Request $request)
    { 
        $date = Carbon::now();
        $visitorid = $request->visitorid;
        $userid = $request->userid;
        $priceinusd = false;
        $invoicedate = $request->invoicedate;
        
        $visitorupdate = Visitor::find($request->visitorid);
        $visitorupdate->gstn = $request->gstn; 
        $visitorupdate->save();

        $user = User::where('CustomerID', $request->userid)->first();
        $visitor = Visitor::where('id', $request->visitorid)->first();

         $curr_date_month = date('m');
        if($curr_date_month > 3)
        {
            $y = date('Y');
            $pt = date('Y', strtotime('+1 year'));
            $fy = substr( $y, -2)."-".substr( $pt, -2);
        }
        else
        {
            $y = date('Y', strtotime('-1 year'));
            $pt = date('Y');
            $fy = substr( $y, -2)."-".substr( $pt, -2);
        }
        $obj = QuotationList::where('fyear', $fy)
        ->where('type', 'Quotation')
        ->orderBy('id', 'desc')->first();
        $serialno = '001';
        if($obj){
            $serialno = $obj->serialno + 1;
        }else{
            $serialno = '001';
        }
        $serialno = str_pad($serialno,3,"0",STR_PAD_LEFT);
        $CustomerName = $user->CustomerName;
        $firstlatter = substr($CustomerName, 0, 1);
        $lastlatter = substr($CustomerName, strlen($CustomerName)-1);
        $shortname  = strtoupper($firstlatter).strtoupper($lastlatter);

        $quotation_displayname  = $user->quotation_displayname;
        $refno=$fy.''.$quotation_displayname.'-'.$serialno.'-'.$visitor->name;

        $machine = $request->machine;
        $machineprice = $request->machineprice;
        $machinqty = $request->machinqty;
        $machinList = [];

        $totalamount = 0;
        if(isset($request->machine) && count($machine) > 0){
            
            if(count($machine) == 1 && $machine[0] == null){
                $machinList = [];
            }else{
                //$machineprice = $request->machineprice;

                $ids_machine = implode(',', $machine);
               
                $machinList = Product::whereIn('id',$machine)->orderByRaw("FIELD(id, $ids_machine)")->get(); //->orderBy('name', 'asc') 
                $i = 0;
               
                foreach($machinList as $machins){
                    $machins->qty = (int)$machinqty[$i];
                    $machins->price = (float)$machineprice[$i];
                    $machins->machineamount = (float)$machins->price * (int)$machinqty[$i];

                    $gstamount = ((float)$machins->price * $machins->gst) / 100;
                    $machins->gsttotalamount = $gstamount * (int)$machinqty[$i];

                    $machins->grand_total = $machins->machineamount + $machins->gsttotalamount;
                    $totalamount += $machins->grand_total;
                    $i++; 
                }                
            }
        }else{
            $machinList = [];
        }
        
        $quotationconfig = QuotationConfiguration::first();
        $quotationconfig->term_condition = $request->term_condition;

        $data = [
            'user'=>$user,
            'visitor'=>$visitor,
            'machinList'=>$machinList,
            'refno' => $refno,
            'invoicedate'=> $invoicedate,
            'quotationconfig' => $quotationconfig
        ];
        //dd($data);

        $t=time();
        $refno_name = preg_replace('/[^A-Za-z0-9\-]/', '_', $refno);
        //$refno_name = 'test';
        $name=$date->format('Y-m-d').'_'.$refno_name;        
        $pdf = PDF::loadView('newquotation/quotationpdf', $data);
        //return view('newquotation/quotationpdf',$data);
        // return $pdf->stream();
        $pdfFileName = $name . '.pdf';
        $path1 = public_path('uploads/quotation'); // Correct path without '../public'

        // Check if the directory exists, if not, create it
        if (!File::exists($path1)) {
            File::makeDirectory($path1, 0755, true, true);
        }

        // Save the PDF file
        $pdf->save($path1 . '/' . $pdfFileName);
        
        $url = asset('uploads/quotation/'.$pdfFileName);
        
        $obj = new QuotationList();
        $obj->visitorid = $request->visitorid;
        $obj->userid    = $request->userid;
        $obj->priceinusd = $priceinusd;
        $obj->pdffile = $pdfFileName;
        $obj->type = 'Quotation';
        $obj->detail = $data;
        $obj->amount = $totalamount;
        $obj->fyear     = $fy;
        $obj->serialno = $serialno;
        $obj->refno = $refno;
        $obj->created_at = date('Y-m-d H:i:s');
        $obj->updated_at = date('Y-m-d H:i:s');
        $obj->save();

        Alert::success('Congrats', 'You have Successfully Quotation Generated');
        return redirect()->route('quotations.list');
    }
    

    public function quotation(Request $request)
    {
        $visitorid = $request->visitorid;
        $userid = $request->userid;
        $machinList = Product::orderBy('name', 'asc')->get();
        $visitor = Visitor::where('id', $request->visitorid)->first();
        //dd($visitor);
        $quotationconfig = QuotationConfiguration::first();
        return view('newquotation/add',compact('visitorid','userid','machinList','visitor','quotationconfig'));
    }
    public function generatequotation(Request $request)
    {    
       
        $date = Carbon::now();
        $visitorid = $request->visitorid;
        $userid = $request->userid;
        $priceinusd = false;
        $invoicedate = $request->invoicedate;

        $visitorupdate = Visitor::find($request->visitorid);
        $visitorupdate->gstn = $request->gstn; 
        $visitorupdate->save();

        $user = User::where('CustomerID', $request->userid)->first();
        $visitor = Visitor::where('id', $request->visitorid)->first();

        $curr_date_month = date('m');
        if($curr_date_month > 3)
        {
            $y = date('Y');
            $pt = date('Y', strtotime('+1 year'));
            $fy = substr( $y, -2)."-".substr( $pt, -2);
        }
        else
        {
            $y = date('Y', strtotime('-1 year'));
            $pt = date('Y');
            $fy = substr( $y, -2)."-".substr( $pt, -2);
        }
        $obj = QuotationList::where('fyear', $fy)
        ->where('type', 'Quotation')
        ->orderBy('id', 'desc')->first();
        $serialno = '001';
        if($obj){
            $serialno = $obj->serialno + 1;
        }else{
            $serialno = '001';
        }
        $serialno = str_pad($serialno,3,"0",STR_PAD_LEFT);
        $CustomerName = $user->CustomerName;
        $firstlatter = substr($CustomerName, 0, 1);
        $lastlatter = substr($CustomerName, strlen($CustomerName)-1);
        $shortname  = strtoupper($firstlatter).strtoupper($lastlatter);

        $quotation_displayname  = $user->quotation_displayname;
        $refno=$fy.''.$quotation_displayname.'-'.$serialno.'-'.$visitor->name;

        $machine = $request->machine;
        $machineprice = $request->machineprice;
        $machinqty = $request->machinqty;
        $machinList = [];

        $totalamount = 0;
        if(isset($request->machine) && count($machine) > 0){
            
            if(count($machine) == 1 && $machine[0] == null){
                $machinList = [];
            }else{
                //$machineprice = $request->machineprice;

                $ids_machine = implode(',', $machine);
               
                $machinList = Product::whereIn('id',$machine)->orderByRaw("FIELD(id, $ids_machine)")->get(); //->orderBy('name', 'asc') 
                $i = 0;
               
                foreach($machinList as $machins){
                    $machins->qty = (int)$machinqty[$i];
                    $machins->price = (float)$machineprice[$i];
                    $machins->machineamount = (float)$machins->price * (int)$machinqty[$i];

                    $gstamount = ((float)$machins->price * $machins->gst) / 100;
                    $machins->gsttotalamount = $gstamount * (int)$machinqty[$i];

                    $machins->grand_total = $machins->machineamount + $machins->gsttotalamount;
                    $totalamount += $machins->grand_total;
                    $i++; 
                }                
            }
        }else{
            $machinList = [];
        }
        
        $quotationconfig = QuotationConfiguration::first();
        $quotationconfig->term_condition = $request->term_condition;

        $data = [
            'user'=>$user,
            'visitor'=>$visitor,
            'machinList'=>$machinList,
            'refno' => $refno,
            'invoicedate'=> $invoicedate,
            'quotationconfig' => $quotationconfig
        ];
        //dd($data);

        $t=time();
        $refno_name = preg_replace('/[^A-Za-z0-9\-]/', '_', $refno);
        //$refno_name = 'test';
        $name=$date->format('Y-m-d').'_'.$refno_name;        
        $pdf = PDF::loadView('newquotation/quotationpdf', $data);
        //return view('newquotation/quotationpdf',$data);
        // return $pdf->stream();
        $pdfFileName = $name . '.pdf';
        $path1 = public_path('uploads/quotation'); // Correct path without '../public'

        // Check if the directory exists, if not, create it
        if (!File::exists($path1)) {
            File::makeDirectory($path1, 0755, true, true);
        }

        // Save the PDF file
        $pdf->save($path1 . '/' . $pdfFileName);
        
        $url = asset('uploads/quotation/'.$pdfFileName);
        
        $obj = new QuotationList();
        $obj->visitorid = $request->visitorid;
        $obj->userid    = $request->userid;
        $obj->priceinusd = $priceinusd;
        $obj->pdffile = $pdfFileName;
        $obj->type = 'Quotation';
        $obj->detail = $data;
        $obj->amount = $totalamount;
        $obj->fyear     = $fy;
        $obj->serialno = $serialno;
        $obj->refno = $refno;
        $obj->created_at = date('Y-m-d H:i:s');
        $obj->updated_at = date('Y-m-d H:i:s');
        $obj->save();

        //return redirect()->back()->with('success', $pdfFileName); 
        return redirect()->route('quotationgenerated',['url'=> $url]);
    }
    public function quotationgenerated(Request $request)
    {
        $url = $request->url;
    }


}