<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Visitor;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Product;
use App\Models\Quotation;
use PDF;

class QuotationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function quotation(Request $request)
    {
        $visitorid = $request->visitorid;
        $userid = $request->userid;
        $machinList = Product::orderBy('name', 'asc')->get();
        return view('quotation/add',compact('visitorid','userid','machinList'));
    }
    public function generatequotation(Request $request)
    {    
       
        $date = Carbon::now();
        $visitorid = $request->visitorid;
        $userid = $request->userid;
        $priceinusd = false;
        $gstn = $request->gstn;
        $visitor = Visitor::find($request->visitorid);
        $visitor->gstn = $gstn;
        $visitor->save();
        
        $invoicenumber = $request->invoicenumber;
        $invoicedate = $request->invoicedate;
        $modeofpayment = $request->modeofpayment;
        $gst = $request->gst;
        

        $user = User::where('CustomerID', $request->userid)->first();
        $visitor = Visitor::where('id', $request->visitorid)->first();

        $curr_date_month = date('m');
        if($curr_date_month > 3)
        {
            $y = date('Y');
            $pt = date('Y', strtotime('+1 year'));
            $fy = substr( $y, -2)."-".substr( $pt, -2);
        }
        else
        {
            $y = date('Y', strtotime('-1 year'));
            $pt = date('Y');
            $fy = substr( $y, -2)."-".substr( $pt, -2);
        }
        $obj = Quotation::where('userid', $request->userid)->where('fyear', $fy)
        ->where('type', 'Quotation')
        ->orderBy('id', 'desc')->first();
        $serialno = '001';
        if($obj){
            $serialno = $obj->serialno + 1;
        }else{
            $serialno = '001';
        }
        $serialno = str_pad($serialno,3,"0",STR_PAD_LEFT);
        $CustomerName = $user->CustomerName;
        $firstlatter = substr($CustomerName, 0, 1);
        $lastlatter = substr($CustomerName, strlen($CustomerName)-1);
        $shortname  = strtoupper($firstlatter).strtoupper($lastlatter);

        $quotation_displayname  = $user->quotation_displayname;
        $refno=$fy.''.$quotation_displayname.'-'.$serialno.'-'.$visitor->company_name;

        $machine = $request->machine;
        $machineprice = $request->machineprice;
        $machinqty = $request->machinqty;
        $machinList = [];

      
        if(isset($request->machine) && count($machine) > 0){
            
            if(count($machine) == 1 && $machine[0] == null){
                $machinList = [];
            }else{
                //$machineprice = $request->machineprice;

                $ids_machine = implode(',', $machine);
               
                $machinList = Product::whereIn('id',$machine)->orderByRaw("FIELD(id, $ids_machine)")->get(); //->orderBy('name', 'asc') 
                $i = 0;
               
                foreach($machinList as $machins){
                    $machins->price = (float)$machineprice[$i];
                    $machins->qty = (int)$machinqty[$i];
                    $i++; 
                }                
            }
        }else{
            $machinList = [];
        }
        
        $data = [
            'user'=>$user,
            'visitor'=>$visitor,
            'machinList'=>$machinList,
            'invoicenumber' => $invoicenumber,
            'invoicedate'=> $invoicedate,
            'modeofpayment'=> $modeofpayment,
            'gst' =>$request->gst,
            'gstn' =>$request->gstn
        ];
        

        $t=time();
        $refno_name = preg_replace('/[^A-Za-z0-9\-]/', '_', $refno);
        //$refno_name = 'test';
        $name=$date->format('Y-m-d').'_'.$refno_name;        
        $pdf = PDF::loadView('quotation/quotationpdf', $data);
        // return $pdf->stream();
        $pdfFileName = $name . '.pdf';
        $path1 = public_path('uploads/quotation'); // Correct path without '../public'

        // Check if the directory exists, if not, create it
        if (!File::exists($path1)) {
            File::makeDirectory($path1, 0755, true, true);
        }

        // Save the PDF file
        $pdf->save($path1 . '/' . $pdfFileName);
        
        $url = asset('uploads/quotation/'.$pdfFileName);
        
        //return redirect()->back()->with('success', $pdfFileName); 
        return redirect()->route('quotationgenerated',['url'=> $url]);
    }
    public function quotationgenerated(Request $request)
    {
        $url = $request->url;
    }
    
    

}
