<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\Models\EmailBatch;
use App\Models\EmailBatchLog;
use App\Models\Visitor;
use App\Models\User;
use App\Models\EmailDraft;
use App\Classes\PHPMailer;
use DB;

class ScheduleCronController extends Controller
{
    public function __construct()
    {
        
    }
    public function getEmailConfig()
    {
        $mailConfigData = DB::table('email_config')->first();
        return $mailConfigData;
    }
    public function getUserEmailConfig($fk_user_id)
    {
        $mailConfigData = DB::table('user_email_config')->where('fk_user_id','=',$fk_user_id)->first();
        return $mailConfigData;
    }
    public function getBatchData()
    {
        $emailBatch = EmailBatch::whereRaw("status = 'pending' and date(`schedule_date`) <= CURDATE()")->get();
        return $emailBatch;
         
    }
    public function getBatchLogData($batchData)
    {
        $emailBatchlog = EmailBatchLog::where('batch_id','=',$batchData->id)
                                    ->where('id','>',$batchData->last_id_sent)
                                    ->where('status','=','pending')
                                    ->limit($batchData->hour_interval_mails)->get();
        return $emailBatchlog;
    }
    public function getBatchLogLastData($batchData)
    {
        $emailBatchloglastdata = EmailBatchLog::where('batch_id','=',$batchData->id)
                                    ->where('id','>',$batchData->last_id_sent)
                                    ->where('status','!=','pending')
                                    ->orderBy('id', 'DESC')
                                    ->limit($batchData->hour_interval_mails)->first();
        return $emailBatchloglastdata;
    }
    public function getVisitorData($visitorId)
    {
        $visitor = Visitor::where('id','=',$visitorId)->first();
        return $visitor;
    }
    public function getTeamMemberData($userId)
    {
        $user = User::where('CustomerID','=',$userId)->first();
        return $user;
    }
    public function getEmailDraftData($id)
    {
        $emaildraft = EmailDraft::where('id', $id)->first();
        return $emaildraft;
    }
    public function updateBatchLog($id,$status)
    {
        $emailBatchlog = EmailBatchLog::find($id);
        $emailBatchlog->status = $status;
        $emailBatchlog->updated_at = date('Y-m-d H:i:s');
        $emailBatchlog->save();

        return true;
    }
    public function updateBatch($id,$field,$value)
    {
        $email_batch = DB::statement("update `email_batch` set `".$field."` = '".$value."', `email_batch`.`updated_at` = '".date('Y-m-d H:i:s')."' where `email_batch`.`id` = ".$id);
        return true;
    }
    public function visitormailschedulecron(Request $request)
    {
        $pendingMailBatches = $this->getBatchData();
        $mailConfigData = $this->getEmailConfig();
        //dd($pendingMailBatches);
        if(empty($mailConfigData)){
            return json_encode([
                'status' => false,
                'message' => 'Mail could not be sent because config data not found!'
            ]);
        }

        if( !empty($pendingMailBatches) && count($pendingMailBatches) > 0 ){
            foreach($pendingMailBatches as $batchData)
            {
                $pendingBatchEmails = $this->getBatchLogData($batchData);
                
                //dd($pendingBatchEmails);
                
                echo  "Hour Interval ==> ".$batchData->hour_interval_mails."<br>";
                echo  "Total Record Get ==> ".count($pendingBatchEmails)."<br>";
                echo  "CC Email Get ==> ".$batchData->ccemail."<br>";
                if(count($pendingBatchEmails) > 0) {
                    foreach ($pendingBatchEmails as $emailBatchLog)
                    {
                        $visitor = $this->getVisitorData($emailBatchLog->visitor_id);
                        if(!empty($visitor)){
                            $teamMember = $this->getTeamMemberData($visitor->customer_id);
                            if(!empty($teamMember)){
                                //print_r($teamMember);
                                $emailDraft = null;
                                /*switch ($batchData->email_type){
                                    case 'primary' :
                                        if($teamMember->primary_email){
                                            $emailDraft = $this->getEmailDraftData($teamMember->primary_email);
                                        }
                                        break;
                                    case 'followup' :
                                        if($teamMember->follow_up_email) {
                                            $emailDraft = $this->getEmailDraftData($teamMember->follow_up_email);
                                        }
                                        break;
                                    case 'other' :
                                        if($batchData->email_draft_id) {
                                            $emailDraft = $this->getEmailDraftData($batchData->email_draft_id);
                                        }
                                        break;
                                }*/
                                $emailDraft = $this->getEmailDraftData($batchData->email_draft_id);
                                if(!empty($emailDraft))
                                {
                                    
                                    $data = [];
                                    if (isset($emailDraft->id)) {
                                        $data['attachments'] = DB::table('email_attachments')->where('email_id', $emailDraft->id)->get();
                                    } else {
                                        $data['attachments'] = null;
                                    }
                                    $data['from_email'] = $teamMember->sender_email;
                                    $data['password'] = '';
                                    $data['from_name'] = $teamMember->sender_name;
                                    $data['receiver_email'] = $visitor->email;
                                    $data['subject'] = $emailDraft->subject;

                                    $emailContent = isset($emailDraft->content) ? $emailDraft->content : "";

                                    $userName =  $visitor->name; 
                                    $companyName = $visitor->company_name; 
                                    $designation =  $visitor->designation;  

                                    $emailContent = str_replace('*user name*', $userName, $emailContent);
                                    $emailContent = str_replace('*company name*', $companyName, $emailContent);
                                    $emailContent = str_replace('*designation*', $designation, $emailContent);
                                    
                                    $data['body'] = $emailContent.'<br>'.$teamMember->signature;

                                    $data['customer_id'] = $visitor->customer_id;
                                    $cc_email = $teamMember->cc_email;
                                    if(isset($batchData->ccemail) && $batchData->ccemail == true){
                                        if($cc_email != null && $cc_email != ""){
                                            $recipients = explode(',', $cc_email);
                                            $data['cc_email'] = $recipients;
                                        }else{
                                            $data['cc_email'] = [];
                                        }
                                         
                                    }else{
                                        $data['cc_email'] = [];
                                        
                                    }
                                    //dd($data['cc_email']);
                                    echo  "From Email ==> ".$data['from_email']."<br>";
                                    echo  "To Email ==> ".$data['receiver_email']."<br>";
                                    // print_r($data);
                                    if(!empty($data['from_email']) && !empty($data['receiver_email']))
                                    {
                                        $result = $this->sendEmail($data);
                                       
                                        if($result) {
                                            $this->updateBatchLog($emailBatchLog->id,'sent');
                                        }else{
                                            $this->updateBatchLog($emailBatchLog->id,'fail');
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $lastRecord = $this->getBatchLogLastData($batchData);
                    
                    if(!empty($lastRecord)){
                        echo "Last Record Id ==> ".$lastRecord->id."<br>";
                        $this->updateBatch($batchData->id,'last_id_sent',$lastRecord->id);
                    }else{
                        
                        $lastRecord = $pendingBatchEmails[count($pendingBatchEmails)-1];
                        //dd($lastRecord);
                        echo "Last Record Id ==> ".$lastRecord->id."<br>";
                        $this->updateBatch($batchData->id,'last_id_sent',$lastRecord->id);
                    }
                    
                }
                $newPendingBatchEmails = $this->getBatchLogData($batchData);
                echo "Pending Emails ==> ".count($newPendingBatchEmails)."<br>";
                if(count($newPendingBatchEmails) == 0) {
                    $this->updateBatch($batchData->id,'status','sent');
                } 
            }
            /*return json_encode([ 
                'status' => true,
                'message' => 'Mail sent successfully!'
            ]);*/
        }else{
            /*return json_encode([
                'status' => false,
                'message' => 'No Batch found!'
            ]);*/
        }
    }
    public function sendEmail($data)
    {
        $emailConfig = $this->getEmailConfig();

        $customer_id = $data['customer_id'];
        $useremailconfig = $this->getUserEmailConfig($customer_id);
        //dd($useremailconfig);
        
        $mail = new PHPMailer();
        $mail->IsSMTP(); // Set mailer to use SMTP
        
        //Enable SMTP debugging
        // 0 = off (for production use)
        // 1 = client messages
        // 2 = client and server messages
        $mail->SMTPDebug = 0;

        if(isset($useremailconfig) && $useremailconfig != null){
            $emailConfig = $useremailconfig;
            $mail->Host = $emailConfig->host; // Specify main and backup server
            //$mail->Host = "Give IP Address"; // If the above does not work.
            $mail->Port = $emailConfig->port; // Set the SMTP port
            $mail->SMTPAuth = true; // Enable SMTP authentication
            $mail->Username = $emailConfig->username; // SMTP username
            $mail->Password = $emailConfig->password; // SMTP password
            $mail->SMTPSecure = $emailConfig->smtp_encryption; // Enable encryption, 'ssl' also accepted
        }else{
            $mail->Host = $emailConfig->host; // Specify main and backup server
            //$mail->Host = "Give IP Address"; // If the above does not work.
            $mail->Port = $emailConfig->smtp_port; // Set the SMTP port
            $mail->SMTPAuth = true; // Enable SMTP authentication
            $mail->Username = $emailConfig->username; // SMTP username
            $mail->Password = $emailConfig->password; // SMTP password
            $mail->SMTPSecure = $emailConfig->smtp_encryption; // Enable encryption, 'ssl' also accepted
        }

        $mail->From = $data['from_email'];
        $mail->FromName = $data['from_name'];

        $mail->AddAddress($data['receiver_email']); // Add a recipient
        if(count($data['cc_email']) > 0){
            $recipients = $data['cc_email'];
            foreach($recipients as $ccemail)
            {
               $mail->AddCC($ccemail, $data['from_name']);
            }
        }
        $mail->IsHTML(true); // Set email format to HTML

        $sub = '=?UTF-8?B?'.base64_encode($data['subject']).'?=';
        $mail->Subject = $sub;
        $mail->Body = $data['body'];
        if (isset($data['attachments'])) {
            // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
            //$url = "../../frenzincrm/public/uploads/email/attachments/";
            $url = public_path(UPLOAD_EMAIL);

            foreach ($data['attachments'] as $key => $attach) {
                $attachmentPath = $url . $attach->attachment;
                $mail->addAttachment($attachmentPath);
            }
        }
        $response = $mail->Send();
        //print_r($data);
        //exit;
        if($response) {
            return true;
        } else {
            return false;
        }
        //return true;

    }
}
