<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\SourceOfLeadDataTable;
use App\Models\SourceOfLead;
use DB;
use Alert;
use Carbon\Carbon;

class SourceOfLeadController extends Controller
{
    public function index(Request $request, SourceOfLeadDataTable $dataTable)
    {
        $leads = SourceOfLead::pluck('name', 'id')->toArray();
        return $dataTable->with([
            'lead_id' => $request->lead_id,
        ])->render('source_of_lead.index', compact('leads'));
    }
    public function addView(Request $request)
    {
        if (isset($request->id)) {
            $data['lead'] = SourceOfLead::where('id', $request->id)->first();
        } else {
            $data['lead'] = '';
        }
        return view('source_of_lead.add', $data);
    }

    public function store(Request $request)
    {       
        if ($request->action == 'insert') {
        
            foreach ($request->name as $name) {
                if(!empty($name)){
                    $obj = new SourceOfLead();
                    $obj->name = $name;
                    $obj->created_at = date('Y-m-d H:i:s');
                    $obj->save();
                }               
            }            
            Alert::success('Congrats', 'You have successfully submitted the data.');
            return redirect('source_of_lead/list');
        } else {
            // Update a single record for the edit action
            $obj = SourceOfLead::find($request->id);
            
            if ($obj) {
                $obj->name = $request->name; 
                $obj->updated_at =  date('Y-m-d H:i:s');
                $obj->save();                
                Alert::success('Congrats', 'Source Of Lead has been updated successfully.');
                return redirect('source_of_lead/list');
            } else {
                Alert::error('Error', 'Category not found.');
                return redirect('source_of_lead/list');
            }
        }
        
    }
    public function destroy($id)
    {
        try {
            SourceOfLead::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
