<?php

namespace App\Http\Controllers;
use App\DataTables\TemplatesDataTable;
use App\Models\Template;
use DB;
use Auth;
use Alert;
use Illuminate\Http\Request;
use Response;
use PDF;
use Carbon\Carbon;

class TemplateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request,TemplatesDataTable $dataTable)
    {
    
       /* $templates = Template::where('whatsapp_template_id','!=',null)
                        ->where('status','PENDING')
                        ->get();
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        // dd($templates);
        foreach($templates as $template){
            $url = 'https://graph.facebook.com/v21.0/'.$template->whatsapp_template_id;
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $whatsappConfig->token
            ]);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $response = json_decode($response);
            //dd($response);
            if($response){
                if($response->status == 'APPROVED') {
                    $templateData = [
                        'status' => $response->status,
                        'approved_at' => now()
                    ];
                }else{
                    $templateData = [
                        'status' => $response->status
                    ];
                }
                $template->update($templateData);
            }
        }
        */

        $whatsappConfig = DB::table('whatsapp_configs')->first();

         $url = 'https://graph.facebook.com/v21.0/'.$whatsappConfig->waba_id.'/message_templates';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $whatsappConfig->token
            ]);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $response = json_decode($response);
            //dd($response);
          $apiResponse = $response->data;

    foreach ($apiResponse as $templateData) {
        $id = $templateData->id ?? null;
        $name = $templateData->name ?? null;
        $category = $templateData->category ?? null;
        $status = $templateData->status ?? null;

        $headerFormat = null;
        $headerText = null;
        $bodyText = null;
        $footerText = null;
        $filetype = null;

        foreach ($templateData->components as $component) {
            if ($component->type === 'HEADER') {
                $headerFormat = $component->format ?? null;
                if ($headerFormat === 'TEXT') {
                    $headerText = $component->text ?? null;
                } else {
                    $filetype = ($headerFormat === 'IMAGE') ? 'image' : 'pdf';
                    $headerText = '';
                }
            } elseif ($component->type === 'BODY') {
                $bodyText = $component->text ?? null;
            } elseif ($component->type === 'FOOTER') {
                $footerText = $component->text ?? null;
            }
        }

        if ($id && $name) {
            Template::updateOrCreate(
                ['whatsapp_template_id' => $id],
                [
                    'name' => $name,
                    'created_by' => 1, // Adjust based on your application logic
                    'category' => $category,
                    'status' => $status,
                    'header_format' => $headerFormat,
                    'header' => $headerText,
                    'message' => $bodyText,
                    'footer' => $footerText,
                    'file_type' => $filetype,
                ]
            );
        } else {
            \Log::warning('Template data missing ID or Name.', ['templateData' => $templateData]);
        }
    }



        return $dataTable->render('template.index');

    }

    public function add()
    {
        return view('template.add');

    }

    public function store(Request $request)
    {
        $requestData = $request->only([
            'name','header','message','footer','file_type','image','pdf'
        ]);
        $request->validate([
            'name' => 'required',
            'message' => 'required',
            'footer' => 'required',
        ]);
        $requestData['status'] = 'NEW';
        $requestData['created_by'] = Auth::user()->user_id ?? null;
        //dd($requestData);
        $template = Template::create($requestData);

        if ($request->file('image') || $request->file('pdf')) {
            if($request->file('image')){
                $file = $request->file('image');
            }else{
                $file = $request->file('pdf');
            }
            // dd($file->getSize(),$file->getClientMimeType());
            $name = str_replace(' ', '_', $file->getClientOriginalName());
            $ext = $file->getClientOriginalExtension();
            $size = $file->getSize();
            $mimeType = $file->getClientMimeType();
            //$image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../public/uploads/template/'.$template->id.'/');
            $success = $file->move($path,$name);

            $requestData['file'] = $name;

            $template->update([
                'file' => $requestData['file'],
                'file_size_in_bytes' => $size,
                'file_mime_type' => $mimeType,
            ]);
        }

        // Alert::success('Congrats', 'You have Successfully Inserted Data');
        return redirect()->route('template.list')->with('success','You have Successfully Inserted Data');
    }

    public function edit(Template $template)
    {

        return view('template.edit', compact('template'));
    }

    public function update(Request $request, Template $template)
    {
        //dd($request->all());

        $requestData = $request->only([
            'name','header','message','footer','file_type','image','pdf'
        ]);
        $request->validate([
            'name' => 'required',
            'message' => 'required',
            'footer' => 'required',
        ]);

        $template->update($requestData);

        if ($request->file('image') || $request->file('pdf')) {
            if($request->file('image')){
                $file = $request->file('image');
            }else{
                $file = $request->file('pdf');
            }
            $name = str_replace(' ', '_', $file->getClientOriginalName());
            $ext = $file->getClientOriginalExtension();
            $size = $file->getSize();
            $mimeType = $file->getClientMimeType();
            //$image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../public/uploads/template/'.$template->id.'/');
            $success = $file->move($path,$name);

            $requestData['file'] = $name;

            $template->update([
                'file' => $requestData['file'],
                'file_size_in_bytes' => $size,
                'file_mime_type' => $mimeType,
            ]);
        }

        // Alert::success('Congrats', 'You have Successfully Updated Data');
        return redirect()->route('template.list')->with('success','You have Successfully Updated Data');
    }

    public function destroy($id)
    {
        try {
            Template::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }

    public function updateDefault(Request $request,$id)
    {
        try {
            Template::where('id', $id)->update(['is_default'=>$request->checkedValue == 'true' ? true : false]);
            Template::where('id', '!=', $id)->update(['is_default'=>false]);
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }

    public function sendApproval(Request $request, Template $template)
    {
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        // dd($whatsappConfig);
        if($whatsappConfig){
            // check to upload file or not
            $headerHandle = null;
            $step3Response = null;
            if($template->file_type){
                // upload file to media api
                $mediaUploadUrl = 'https://graph.facebook.com/v21.0/'.$whatsappConfig->phone_id.'/media';
                $mediaData = [
                    'messaging_product' => 'whatsapp',
                    'file' => new \CURLFile($template->file_url_new,$template->file_mime_type)
                ];
                $ch = curl_init($mediaUploadUrl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $mediaData);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: multipart/form-data',
                    'Authorization: Bearer ' . $whatsappConfig->token
                ]);
                $mediaUploadResponse = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                $mediaUploadResponse = json_decode($mediaUploadResponse);
                // dd($mediaUploadResponse);

                if($mediaUploadResponse){
                    if($mediaUploadResponse->id){
                        $template->update(['whatsapp_file_id'=>$mediaUploadResponse->id]);
                    }
                }

                $fileUploadUrl = 'https://graph.facebook.com/v21.0/'.$whatsappConfig->app_id.'/uploads';
                $data = [
                    'file_length' => $template->file_size_in_bytes,
                    "file_type" => $template->file_mime_type
                ];
                $ch = curl_init($fileUploadUrl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $whatsappConfig->token
                ]);
                $step1Response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                $step1Response = json_decode($step1Response);
                //dd($step1Response);

                if($step1Response){
                    if($step1Response->id){
                        $fileUploadUrl2 = 'https://graph.facebook.com/v21.0/'.$step1Response->id;
                        $ch = curl_init($fileUploadUrl2);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, file_get_contents($template->file_url_new));
                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'file_offset: 0',
                            'Content-Type: '.$template->file_mime_type,
                            'Authorization: OAuth ' . $whatsappConfig->token
                        ]);
                        $step2Response = curl_exec($ch);
                        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                        curl_close($ch);
                        $step2Response = json_decode($step2Response);
                        //dd($step2Response);

                        if($step2Response){
                            if($step2Response->h){
                                $headerHandle = $step2Response->h;
                            }
                        }
                    }
                }
                // dd($response->id);
            }

            //dd($headerHandle);

             if($headerHandle){
                $fileUploadUrl3 = 'https://graph.facebook.com/v21.0/'.$whatsappConfig->waba_id.'/message_templates';

                if($template->file_type=='image')
                {
                $data = [
                    "name" => $template->name,
                    "language" => "en",
                    "category" => "MARKETING",
                    "components" => [
                        [
                            "type" => "HEADER",
                            "format" => "IMAGE",
                            "example" => [
                                "header_handle" => [
                                    $headerHandle
                                ]
                            ]
                        ],
                        [
                            "type" => "BODY",
                            "text" => $template->message
                        ],
                        [
                            "type" => "FOOTER",
                            "text" => $template->footer
                        ]
                    ]
                ];
                }
                else if($template->file_type=='pdf')
                {
                $data = [
                    "name" => $template->name,
                    "language" => "en",
                    "category" => "MARKETING",
                    "components" => [
                        [
                            "type" => "HEADER",
                            "format" => "DOCUMENT",
                            "example" => [
                                "header_handle" => [
                                    $headerHandle
                                ]
                            ]
                        ],
                        [
                            "type" => "BODY",
                            "text" => $template->message
                        ],
                        [
                            "type" => "FOOTER",
                            "text" => $template->footer
                        ]
                    ]
                ];
                }

                //dd($data);
                $ch = curl_init($fileUploadUrl3);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $whatsappConfig->token
                ]);
                $step3Response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                $step3Response = json_decode($step3Response);
                //dd($step3Response);
            }else{
                $fileUploadUrl3 = 'https://graph.facebook.com/v21.0/'.$whatsappConfig->waba_id.'/message_templates';
                $data = [
                    "name" => $template->name,
                    "language" => "en",
                    "category" => "MARKETING",
                    "components" => [
                        [
                            "type" => "HEADER",
                            "format" => "TEXT",
                            "text" => $template->header
                        ],
                        [
                            "type" => "BODY",
                            "text" => $template->message
                        ],
                        [
                            "type" => "FOOTER",
                            "text" => $template->footer
                        ]
                    ]
                ];
                $ch = curl_init($fileUploadUrl3);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $whatsappConfig->token
                ]);
                $step3Response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                $step3Response = json_decode($step3Response);
                // dd($step3Response);
            }
            if($step3Response){
                //dd($step3Response); //check for error
                if($step3Response->id){
                    if($step3Response->status == 'APPROVED') {
                        $templateData = [
                            'whatsapp_template_id' => $step3Response->id,
                            'status' => $step3Response->status,
                            'approved_at' => now()
                        ];
                    }else{
                        $templateData = [
                            'whatsapp_template_id' => $step3Response->id,
                            'status' => $step3Response->status
                        ];
                    }
                    $template->update($templateData);
                }
            }
            return response()->json([
                "status" => true,
            ]);

        }else{
            return response()->json([
                "status" => false,
            ]);
        }
    }

    public function sendTestMessage(Request $request,$id)
    {
        //dd($request->all(),$id);
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        $template = Template::where('id',$id)->first();
        // dd($whatsappConfig);
        if($whatsappConfig){
            $sendTestMessageUrl = 'https://graph.facebook.com/v21.0/'.$whatsappConfig->phone_id.'/messages';
            if($template->file_type){
                if($template->file_type == 'image'){
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $request->number,
                        "type" => "template",
                        "template" => [
                            "name" =>  $template->name,
                            "language" => [
                                "code" => "en"
                            ],
                            "components" => [
                                [
                                    "type" => "header",
                                    "parameters" => [
                                        [
                                            "type" => "image",
                                            "image" => [
                                                "id" => $template->whatsapp_file_id
                                            ]
                                        ]
                                    ]
                                ]
                                ]
                        ]
                    ];
                }else{
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $request->number,
                        "type" => "template",
                        "template" => [
                            "name" =>  $template->name,
                            "language" => [
                                "code" => "en"
                            ],
                            "components" => [
                                [
                                    "type" => "header",
                                    "parameters" => [
                                        [
                                            "type" => "DOCUMENT",
                                            "document" => [
                                                "id" => $template->whatsapp_file_id
                                            ]
                                        ]
                                    ]
                                ]
                                ]
                        ]
                    ];
                }
            }else{
                $data = [
                    "messaging_product" => "whatsapp",
                    "to" => $request->number,
                    "type" => "template",
                    "template" => [
                          "name" =>  $template->name,
                          "language" => [
                             "code" => "en"
                          ]
                       ]
                 ];
            }
            $ch = curl_init($sendTestMessageUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $whatsappConfig->token
            ]);
            $sendTestMessageResponse = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $sendTestMessageResponse = json_decode($sendTestMessageResponse);
            //dd($sendTestMessageResponse);
            if(isset($sendTestMessageResponse->error)){
                return response()->json([
                    "status" => false,
                    "message" => $sendTestMessageResponse->error->message,
                    "response" => $sendTestMessageResponse
                ]);
            }
            return response()->json([
                "status" => true,
                "message" => "Message send successfully",
                "response" => $sendTestMessageResponse
            ]);

        }
        return response()->json([
            "status" => false,
            "message" => "Configuration not found",
            "response" => null
        ]);
    }
}
