<?php

namespace App\Http\Controllers;

use App\Models\EventMetaForms;
use App\Models\IntegrationConfig;
use Illuminate\Http\Request;
use App\Models\Visitor;
use App\Models\Template;
use DB;
use Illuminate\Support\Facades\Log;
use App\Models\WhatsappLog;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Http;

class VisitorIndiaMartScheduleCronController extends Controller
{

    protected $facebookBaseUrl = "https://graph.facebook.com/v23.0/";
    public function __construct() {}
    public function getConfig()
    {
        $config = DB::table('configs')->first();
        return $config;
    }
    public function visitorindiamartschedulecron()
    {

        $configdata = $this->getConfig();
        //dd($configdata);
        if (isset($configdata)) {
            $id = $configdata->id;
            $indiamartkey = $configdata->indiamartkey;
            $indiamartkey_url = 'https://mapi.indiamart.com/wservce/crm/crmListing/v2/?glusr_crm_key=' . $indiamartkey;
            //$configdata->indiamartkey_url;
            $indiamart_event_id = $configdata->indiamart_event_id;
            $indiamart_user_id = $configdata->indiamart_user_id;

            $url = $indiamartkey_url;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            $result  = curl_exec($ch);
            $outData = json_decode($result, true);

            foreach ($outData['RESPONSE'] as $response) {
                $UNIQUE_QUERY_ID = $response['UNIQUE_QUERY_ID'];
                $SENDER_NAME = addslashes($response['SENDER_NAME']);
                $SENDER_COMPANY = addslashes($response['SENDER_COMPANY']);
                $SENDER_MOBILE = $response['SENDER_MOBILE'];
                $SENDER_MOBILE_ALT = $response['SENDER_MOBILE_ALT'];
                $SENDER_PHONE_ALT = $response['SENDER_PHONE_ALT'];
                $SENDER_EMAIL = $response['SENDER_EMAIL'];
                $SENDER_EMAIL_ALT = $response['SENDER_EMAIL_ALT'];
                $SENDER_STATE = $response['SENDER_STATE'];
                $SENDER_CITY = $response['SENDER_CITY'];
                $SENDER_ADDRESS = $response['SENDER_ADDRESS'];
                $SENDER_PINCODE = $RESPONSE['SENDER_PINCODE'];
                $SENDER_COUNTRY_ISO = $RESPONSE['SENDER_COUNTRY_ISO'];
                $QUERY_TIME = $response['QUERY_TIME'];
                $QUERY_MESSAGE = addslashes($response['QUERY_MESSAGE']);
                $QUERY_TYPE = $response['QUERY_TYPE'];
                $country_code = '+91-';
                $mobilenumber = preg_replace('/^\+?+91-|\|+91-|\D/', '', ($SENDER_MOBILE));
                $mobilenumber_alt = preg_replace('/^\+?+91-|\|+91-|\D/', '', ($SENDER_MOBILE_ALT));

                // Building the remarks string
                $LEAD_TYPE = "";
                if ($QUERY_TYPE == "W") {
                    $LEAD_TYPE = "Direct Inquiry";
                } else if ($QUERY_TYPE == "BL") {
                    $LEAD_TYPE = "Buy Lead";
                } else if ($QUERY_TYPE == "P") {
                    $LEAD_TYPE = "PNS Calls";
                } else if ($QUERY_TYPE == "V / BIZ") {
                    $LEAD_TYPE = "Catalog-View Leads";
                } else if ($QUERY_TYPE == "WA") {
                    $LEAD_TYPE = "WhatsApp Enquiries";
                }

                $REMARKS = "Query Type: $LEAD_TYPE\n";
                $REMARKS .= "Product: $QUERY_PRODUCT_NAME\n";
                $REMARKS .= "Message: $QUERY_MESSAGE";

                $datetime = date("Y-m-d H:i:s");

                $vdata = [
                    'indiamart_query_id'      => $UNIQUE_QUERY_ID,
                    'name'                     => $SENDER_NAME,
                    'event_id'                 => $indiamart_event_id,
                    'customer_id'            => $indiamart_user_id,
                    'company_name'            => $SENDER_COMPANY,
                    'mobile_no'                => $mobilenumber,
                    'mobile_no2'            => $mobilenumber_alt,
                    'mobile_no3'            => $mobilenumber_alt,
                    'email'                    => $SENDER_EMAIL,
                    'email2'                => $SENDER_EMAIL_ALT,
                    'state'                    => $SENDER_STATE,
                    'city'                    => $SENDER_CITY,
                    'pincode'               => $SENDER_PINCODE,
                    'country_code'          => $SENDER_COUNTRY_ISO,
                    'address'                => $SENDER_ADDRESS,
                    'event_ids'             => $indiamart_event_id,
                    'remarks'                => $REMARKS,
                    'visited_date'            => $QUERY_TIME,
                    'created_at'            => $QUERY_TIME,
                    'updated_at'            => $QUERY_TIME
                ];



                $exists = DB::table('visitors')->where('indiamart_query_id', $UNIQUE_QUERY_ID)->exists();

                if (!$exists) {
                    try {
                        DB::table('visitors')->insert($vdata);
                    } catch (\Exception $e) {
                        Log::build([
                            'driver' => 'single',
                            'path' => storage_path('logs/indiamart.log'),
                        ])->info(["India Mart Log error" => $e->getMessage()]);
                    }
                }

                /*echo $sql_insertdata = "INSERT INTO `visitors`
		        (indiamart_query_id,
		        	visitors.name,
		        	event_id,
		        	customer_id,
		        	company_name,
		        	mobile_no,
		        	mobile_no2,
		        	mobile_no3,
		        	email,
		        	email2,
		        	visitors.state,
		        	city,
		        visitors.address,
		        remarks,
		        visited_date,
		        created_at,
		        updated_at)
		        VALUES ('$UNIQUE_QUERY_ID','$SENDER_NAME','$indiamart_event_id','$indiamart_user_id','$SENDER_COMPANY','$mobilenumber',
		        '$mobilenumber_alt','$mobilenumber_alt','$SENDER_EMAIL','$SENDER_EMAIL_ALT','$SENDER_STATE','$SENDER_CITY','$SENDER_ADDRESS','$QUERY_MESSAGE','$QUERY_TIME','$QUERY_TIME','$datetime')";
				$sql_insert = $conn->query($sql_insertdata);*/
            }

            //Log::info('India Mart Log', ['data' => $result]);
            Log::build([
                'driver' => 'single',
                'path' => storage_path('logs/indiamart.log'),
            ])->info(["India Mart Log " => $result]);
        }
    }

    public static function sendRequest(string $method, string $url, array $payload = [], array $headers = [], bool $asJson = true, $logChannel = 'stack'): array
    {
        try {
            // Prepare request
            $request = Http::withHeaders($headers);

            if ($asJson) {
                $request = $request->acceptJson();
            }

            // Send request dynamically
            $response = $request->{$method}($url, $payload);

            // Log request
            Log::channel($logChannel)->info('API Request', [
                'method' => strtoupper($method),
                'url' => $url,
                'payload' => $payload,
                'headers' => $headers
            ]);

            // Decode response
            $responseData = $response->json();

            // Log response
            Log::channel($logChannel)->info('API Response', [
                'status' => $response->status(),
                'response' => $responseData
            ]);

            return $responseData ?? [];
        } catch (\Exception $e) {
            Log::channel($logChannel)->error('API Request Error', [
                'method' => strtoupper($method),
                'url' => $url,
                'payload' => $payload,
                'headers' => $headers,
                'error' => $e->getMessage()
            ]);

            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
    }

    public function visitorFacebookWebHookVerify(Request $request, $appId)
    {
        // Check if required parameters are present
        Log::channel('facebook_webhook')->info(["Facebook Webhook Verify ------>" => $request->all()]);

        if ($request->has(['hub_mode', 'hub_challenge', 'hub_verify_token'])) {
            // Verify the token
            if ($request->input('hub_verify_token') === ($appId . "facebook")) {
                return response($request->input('hub_challenge'), 200);
            } else {
                return response("Invalid verify token", 403);
            }
        } else {
            return response("Missing parameters", 400);
        }
    }

    public function visitorFacebookWebHook(Request $request, $appId)
    {
        try {


            $facebookConfig = IntegrationConfig::where('key', 'facebook')->where('app_id', $appId)->first();

            Log::channel('facebook_webhook')->info(["Facebook Webhook Content all ------>" => $request->all()]);


            $webhookData = $request->all();
            $webhookDataEntry = $webhookData['entry'];
            $webhookDataObject = $webhookData['object'];
            if (!empty($webhookDataEntry)) {
                foreach ($webhookDataEntry as $entry) {
                    $pageId = $entry['id'];
                    $entryTime = $entry['time'];
                    $changes = $entry['changes'];

                    //call pages api
                    $accessToken = $facebookConfig?->access_token; // from integration config
                    $getPageDetailUrl = $this->facebookBaseUrl . 'me/accounts'; // get page detail api

                    if (!empty($accessToken)) {
                        $getPageDetailResponse = $this->sendRequest('GET', $getPageDetailUrl, ['access_token' => $accessToken], [], true, 'facebook_webhook');
                        Log::channel('facebook_webhook')->info(["Facebook Webhook Page (" . $pageId . ") Detail  " => $getPageDetailResponse]);
                        $pages = $getPageDetailResponse['data'];
                        $page = collect($pages)->firstWhere('id', $pageId); //find page by id
                        if (!empty($page)) {
                            $pageAccessToken = $page['access_token'];
                            $category = $page['category'];
                            $category_list = $page['category_list']; //[{id:123,name:test}]
                            $tasks = $page['tasks']; // array of strings
                            $pageName = $page['name']; //name of page

                            Log::channel('facebook_webhook')->info(["Facebook Webhook Page (" . $pageId . ") Detail  " => $page]);

                            foreach ($changes as $change) {
                                $changeValue = $change['value'];
                                $changefield = $change['field']; // leadgen
                                $leadId = $changeValue['leadgen_id'];
                                $changeCreateTime = $changeValue['created_time'] ?? '';
                                $formId = $changeValue['form_id'];

                                //get form detail
                                $getFormDetailUrl = $this->facebookBaseUrl . $formId;
                                $getFormDetailResponse = $this->sendRequest('GET', $getFormDetailUrl, ['access_token' => $pageAccessToken], [], true, 'facebook_webhook');
                                Log::channel('facebook_webhook')->info(["Facebook Webhook Form (" . $formId . ") Detail Api Response" => $getFormDetailResponse]);
                                $formDetail = $getFormDetailResponse;
                               $formName = $formDetail['name'] ?? '';
                                $formStatus = $formDetail['status']; //ACTIVE

                                $eventIdsCommaSeparated = EventMetaForms::where('form_name',$formName)->pluck('event_id')->implode(',');
                                $eventIdsCommaSeparated = $eventIdsCommaSeparated ?? '';


                                $leadDetailUrl = $this->facebookBaseUrl . $leadId;

                                if (!empty($pageAccessToken) && !empty($leadId)) {
                                    $getLeadDetailResponse = $this->sendRequest('GET', $leadDetailUrl, ['access_token' => $pageAccessToken], [], true, 'facebook_webhook');
                                    Log::channel('facebook_webhook')->info(["Facebook Webhook Lead (" . $leadId . ") Detail Api Response" => $getLeadDetailResponse]);

                                    if (!empty($getLeadDetailResponse)) {

                                        $createDateTime = $getLeadDetailResponse['created_time'] ?? '';

                                        $fieldsData = $getLeadDetailResponse['field_data'];
                                        //  [{
                                        //     "name": "full_name",
                                        //     "values": [
                                        //         "Kanti Suthar G"
                                        //     ]
                                        // }]
                                        $fieldFixed = [
                                            "email" => "email",
                                            "phone_number" => "mobile_no",
                                            "street_address" => "address",
                                            "city" => "city",
                                            "state" => "state",
                                            "country" => "address_country_code",
                                            "post_code" => "pincode",
                                            "full_name" => "name",
                                            "work_email" => "email2",
                                            "company_name" => "company_name",
                                        ];

                                        // country_code
                                        // $phone_number = $this->getFieldValue($fieldsData, 'phone_number')['values'][0] ?? '';
                                        $country_code = $this->getFieldValue($fieldsData, 'country');

                                        $visitorData = [];

                                        foreach ($fieldFixed as $key => $value) {
                                            $visitorData[$value] = $this->getFieldValue($fieldsData, $key)['values'][0] ?? '';
                                        }

                                        $visitorData['country_code'] = $country_code['values'][0] ?? '';
                                        $fiexedFieldNames = array_keys($fieldFixed);

                                        $visitorData['event_id'] = $facebookConfig?->event_id ?? '';
                                        //filtered field which is store in remarks
                                        $filteredFields = collect($fieldsData)->reject(function ($field) use ($fiexedFieldNames) {
                                            return in_array($field['name'], $fiexedFieldNames);
                                        })->values();
                                        Log::channel('facebook_webhook')->info(["Not Fixed Fields" => $filteredFields]);

                                        $visitorData['remarks'] = "";
                                        if (!empty($filteredFields)) {
                                            $visitorData['remarks'] = $filteredFields->map(function ($field) {
                                                return $this->humanizeFieldName($field['name']) . " : " . $this->humanizeFieldName(join(' , ', $field['values']));
                                            })->implode("\n");
                                        }
                                        if (!empty($eventIdsCommaSeparated)) {
                                            $visitorData['event_ids'] = $eventIdsCommaSeparated;
                                        }
                                        if (!empty($formName)) {
                                            $append = empty($visitorData['remarks']) ? "" : "\n";
                                            $visitorData['remarks'] .= $append . "Form Name : " . $formName ?? '';
                                        }

                                        $visitorData['customer_id'] = $facebookConfig?->customer_id ?? '';
                                        $visitorData['visited_date'] = Carbon::now('Asia/Kolkata');
                                        Visitor::create($visitorData);


                                        Log::channel('facebook_webhook')->info(["Facebook Webhook Lead (" . $leadId . ") Added to Visitors Table" => json_encode($visitorData)]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(['status' => false, 'message' => $e->getMessage()], 500);
            Log::channel('facebook_webhook')->error(["Webhook error ------>" => $e->getMessage()]);
        }

    }

    function humanizeFieldName($fieldName)
    {
        // Replace underscores with spaces and capitalize words
        return ucwords(str_replace('_', ' ', $fieldName));

    }
    public function getFieldValue($fieldsData, $name)
    {
        return collect($fieldsData)->firstWhere('name', $name);
    }


    public function visitorindiamartcronforolddata()
    {
        $configdata = $this->getConfig();
        if (isset($configdata)) {
            $id = $configdata->id;
            $indiamartkey = $configdata->indiamartkey;
            $indiamart_event_id = $configdata->indiamart_event_id;
            $indiamart_user_id = $configdata->indiamart_user_id;

            // Get last processed end_date or initialize with a default
            $lastEndDate = $configdata->last_processed_date ?? date('Y-m-d', strtotime('-7 days'));
            $startDate = date('Y-m-d', strtotime($lastEndDate . ' +1 day'));
            $today = date('Y-m-d');

            if (strtotime($startDate) <= strtotime($today)) {
                $endDate = date('Y-m-d', strtotime($startDate . ' +6 days'));
                if (strtotime($endDate) > strtotime($today)) {
                    $endDate = $today;
                }

                // Build the API URL for the 7-day interval
                $indiamartkey_url = 'https://mapi.indiamart.com/wservce/crm/crmListing/v2/?glusr_crm_key='
                    . $indiamartkey . '&start_time=' . date('d-M-Y', strtotime($startDate))
                    . '&end_time=' . date('d-M-Y', strtotime($endDate));

                Log::build([
                    'driver' => 'single',
                    'path' => storage_path('logs/indiamart.log'),
                ])->info(["India Mart Log API CAll " => $indiamartkey_url]);

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_URL, $indiamartkey_url);
                $result = curl_exec($ch);
                $outData = json_decode($result, true);

                if (isset($outData['RESPONSE']) && is_array($outData['RESPONSE'])) {
                    foreach ($outData['RESPONSE'] as $response) {
                        $UNIQUE_QUERY_ID = $response['UNIQUE_QUERY_ID'];
                        $SENDER_NAME = addslashes($response['SENDER_NAME']);
                        $SENDER_COMPANY = addslashes($response['SENDER_COMPANY']);
                        $SENDER_MOBILE = $response['SENDER_MOBILE'];
                        $SENDER_MOBILE_ALT = $response['SENDER_MOBILE_ALT'];
                        $SENDER_PHONE_ALT = $response['SENDER_PHONE_ALT'];
                        $SENDER_EMAIL = $response['SENDER_EMAIL'];
                        $SENDER_EMAIL_ALT = $response['SENDER_EMAIL_ALT'];
                        $SENDER_STATE = $response['SENDER_STATE'];
                        $SENDER_CITY = $response['SENDER_CITY'];
                        $SENDER_ADDRESS = $response['SENDER_ADDRESS'];
                        $SENDER_PINCODE = $response['SENDER_PINCODE'];
                        $SENDER_COUNTRY_ISO = $response['SENDER_COUNTRY_ISO'];
                        $QUERY_TIME = $response['QUERY_TIME'];
                        $QUERY_MESSAGE = addslashes($response['QUERY_MESSAGE']);
                        $QUERY_TYPE = $response['QUERY_TYPE'];

                        $LEAD_TYPE = match ($QUERY_TYPE) {
                            "W" => "Direct Inquiry",
                            "BL" => "Buy Lead",
                            "P" => "PNS Calls",
                            "V / BIZ" => "Catalog-View Leads",
                            "WA" => "WhatsApp Enquiries",
                            default => "Unknown"
                        };

                        $REMARKS = "Query Type: $LEAD_TYPE\nMessage: $QUERY_MESSAGE";

                        $vdata = [
                            'indiamart_query_id' => $UNIQUE_QUERY_ID,
                            'name' => $SENDER_NAME,
                            'event_id' => $indiamart_event_id,
                            'customer_id' => $indiamart_user_id,
                            'company_name' => $SENDER_COMPANY,
                            'mobile_no' => preg_replace('/^\+?+91-|\|+91-|\D/', '', $SENDER_MOBILE),
                            'mobile_no2' => preg_replace('/^\+?+91-|\|+91-|\D/', '', $SENDER_MOBILE_ALT),
                            'email' => $SENDER_EMAIL,
                            'email2' => $SENDER_EMAIL_ALT,
                            'state' => $SENDER_STATE,
                            'city' => $SENDER_CITY,
                            'pincode' => $SENDER_PINCODE,
                            'country_code' => $SENDER_COUNTRY_ISO,
                            'address' => $SENDER_ADDRESS,
                            'remarks' => $REMARKS,
                            'visited_date' => $QUERY_TIME,
                            'created_at' => $QUERY_TIME,
                            'updated_at' => $QUERY_TIME
                        ];

                        $exists = DB::table('visitors')->where('indiamart_query_id', $UNIQUE_QUERY_ID)->exists();

                        if (!$exists) {
                            try {
                                DB::table('visitors')->insert($vdata);
                            } catch (\Exception $e) {
                                Log::build([
                                    'driver' => 'single',
                                    'path' => storage_path('logs/indiamart.log'),
                                ])->info(["India Mart Log error" => $e->getMessage()]);
                            }
                        }
                    }
                }

                // Update last processed date in config table
                DB::table('configs')->where('id', $id)->update(['last_processed_date' => $endDate]);

                Log::build([
                    'driver' => 'single',
                    'path' => storage_path('logs/indiamart.log'),
                ])->info(["India Mart Log" => $result]);
            }
        }
    }



    public function indiamart_crm(Request $request)
    {

        try {
            // Validate incoming data for the 'data' field
            // $validator = Validator::make($request->all(), [
            // 	'data' => 'required|array',
            // 	'data.CODE' => 'required|integer',
            // 	'data.STATUS' => 'required|string',
            // 	'data.RESPONSE' => 'required|array',
            // 	'data.RESPONSE.UNIQUE_QUERY_ID' => 'required|integer',
            // 	'data.RESPONSE.SENDER_NAME' => 'required|string|max:255',
            // 	'data.RESPONSE.SENDER_MOBILE' => 'required|string|max:15',
            // 	'data.RESPONSE.SENDER_EMAIL' => 'required|email|max:255',
            // 	'data.RESPONSE.SENDER_COMPANY' => 'required|string|max:255',
            // 	'data.RESPONSE.SENDER_ADDRESS' => 'required|string|max:255',
            // 	'data.RESPONSE.SENDER_CITY' => 'required|string|max:100',
            // 	'data.RESPONSE.SENDER_STATE' => 'required|string|max:100',
            // 	'data.RESPONSE.SENDER_PINCODE' => 'required|string|max:10',
            // 	'data.RESPONSE.SENDER_COUNTRY_ISO' => 'required|string|max:2',
            // 	// Add more fields as necessary...
            // ]);

            // if ($validator->fails()) {
            // 	return response()->json(['status' => 'error', 'message' => 'Invalid input', 'errors' => $validator->errors()], 400);
            // }

            $data = $request->all();

            if (!empty($data)) {

                // Extracting CODE and RESPONSE
                $CODE = $data['CODE'];
                $RESPONSE = $data['RESPONSE'];

                $SENDER_QUERY_TYPE = $RESPONSE['QUERY_TYPE'];
                $QUERY_PRODUCT_NAME = $RESPONSE['QUERY_PRODUCT_NAME'] ?? '';

                if (is_array($RESPONSE['QUERY_MESSAGE'])) {
                    $QUERY_MESSAGE = $RESPONSE['QUERY_MESSAGE']['message_text'];
                    $additional_details = $RESPONSE['QUERY_MESSAGE']['additional_details'] ?? [];
                    $isq = $RESPONSE['QUERY_MESSAGE']['isq'] ?? [];
                } else {
                    $QUERY_MESSAGE_decode = json_decode($RESPONSE['QUERY_MESSAGE'], true); // Decode as an associative array
                    if (json_last_error() === JSON_ERROR_NONE) {
                        $QUERY_MESSAGE = $QUERY_MESSAGE_decode['message_text'];
                        $additional_details = $QUERY_MESSAGE_decode['additional_details'] ?? [];
                        $isq = $QUERY_MESSAGE_decode['isq'] ?? [];
                    } else {
                        $QUERY_MESSAGE = $RESPONSE['QUERY_MESSAGE'];
                        $additional_details = [];
                        $isq = [];
                    }
                }

                // Extracting additional details (like Lead Created)
                $Lead_Created = $additional_details['Lead Created'] ?? 'N/A';

                // Building the remarks string
                $LEAD_TYPE = "";
                if ($SENDER_QUERY_TYPE == "W") {
                    $LEAD_TYPE = "Direct Inquiry";
                } else if ($SENDER_QUERY_TYPE == "BL") {
                    $LEAD_TYPE = "Buy Lead";
                } else if ($SENDER_QUERY_TYPE == "P") {
                    $LEAD_TYPE = "PNS Calls";
                } else if ($SENDER_QUERY_TYPE == "V / BIZ") {
                    $LEAD_TYPE = "Catalog-View Leads";
                } else if ($SENDER_QUERY_TYPE == "WA") {
                    $LEAD_TYPE = "WhatsApp Enquiries";
                }

                $REMARKS = "Query Type: $LEAD_TYPE\n";
                $REMARKS .= "Product: $QUERY_PRODUCT_NAME\n";
                $REMARKS .= "Message: $QUERY_MESSAGE\n";

                // Loop through the isq array to dynamically add all key-value pairs
                if (!empty($isq)) {
                    $REMARKS .= "ISQ Details:\n";
                    foreach ($isq as $key => $value) {
                        $REMARKS .= "$key: $value\n";
                    }
                }

                // Adding additional details like Lead Created
                //$REMARKS .= "Lead Created: $Lead_Created";

                //$REMARKS = "Product: $QUERY_PRODUCT_NAME\nMessage: $QUERY_MESSAGE";
                // Prepare to extract variables from RESPONSE
                $UNIQUE_QUERY_ID = $RESPONSE['UNIQUE_QUERY_ID'];
                $SENDER_NAME = addslashes($RESPONSE['SENDER_NAME']);
                $SENDER_MOBILE = $RESPONSE['SENDER_MOBILE'];
                $SENDER_EMAIL = $RESPONSE['SENDER_EMAIL'];
                $SENDER_COMPANY = addslashes($RESPONSE['SENDER_COMPANY']);
                $SENDER_ADDRESS = $RESPONSE['SENDER_ADDRESS'];
                $SENDER_CITY = $RESPONSE['SENDER_CITY'];
                $SENDER_STATE = $RESPONSE['SENDER_STATE'];
                $SENDER_PINCODE = $RESPONSE['SENDER_PINCODE'] ?? "";
                $SENDER_COUNTRY_ISO = $RESPONSE['SENDER_COUNTRY_ISO'] ?? "IN";
                $SENDER_MOBILE_ALT = $RESPONSE['SENDER_MOBILE_ALT'] ?? null;
                $QUERY_MESSAGE = addslashes($REMARKS) ?? '';
                $QUERY_TIME = $RESPONSE['QUERY_TIME'] ?? '';

                // Sanitize mobile numbers
                $mobilenumber = preg_replace('/^\+?+91-|\|+91-|\D/', '', $SENDER_MOBILE);
                $mobilenumber_alt = preg_replace('/^\+?+91-|\|+91-|\D/', '', $SENDER_MOBILE_ALT);

                // Get config data
                $configdata = $this->getConfig();
                $indiamart_event_id = $configdata->indiamart_event_id;
                $indiamart_user_id = $configdata->indiamart_user_id;

                // Prepare data for insertion
                $vdata = [
                    'indiamart_query_id' => $UNIQUE_QUERY_ID,
                    'name' => $SENDER_NAME,
                    'event_id' => $indiamart_event_id,
                    'customer_id' => $indiamart_user_id,
                    'company_name' => $SENDER_COMPANY,
                    'mobile_no' => $mobilenumber,
                    'mobile_no2' => $mobilenumber_alt,
                    'email' => $SENDER_EMAIL,
                    'state' => $SENDER_STATE,
                    'city' => $SENDER_CITY,
                    'address' => $SENDER_ADDRESS,
                    'pincode' => $SENDER_PINCODE,
                    'country_code' => $SENDER_COUNTRY_ISO,
                    'event_ids' => $indiamart_event_id,
                    'remarks' => $QUERY_MESSAGE,
                    'visited_date' => $QUERY_TIME,
                    'created_at' => $QUERY_TIME,
                    'updated_at' => $QUERY_TIME,
                ];

                // Insert or update the data
                $visitorCreated = Visitor::updateOrCreate(
                    [
                        'indiamart_query_id' => $UNIQUE_QUERY_ID,
                        'mobile_no' => $mobilenumber,
                        'email' => $SENDER_EMAIL,
                    ],
                    $vdata
                );

                Log::build([
                    'driver' => 'single',
                    'path' => storage_path('logs/indiamart.log'),
                ])->info(["India Mart Log push api data" => $request->all()]);

                /* Send WhatsApp Message Start */
                if (!empty($vdata['mobile_no']) && strlen($vdata['mobile_no']) >= 8) {
                    // If the insert or update was successful, try to fetch the visitor's id
                    if ($visitorCreated) {
                        $whatsAppResponse = $this->sendWhatsAppMessage($vdata['mobile_no'], $indiamart_user_id, $visitorCreated->id);
                    } else {
                        Log::build([
                            'driver' => 'single',
                            'path' => storage_path('logs/indiamart.log'),
                        ])->info(["indiamart_crm Cron Job: Invalid Failed to insert or update visitor data." => $request->all()]);
                    }
                } else {
                    Log::build([
                        'driver' => 'single',
                        'path' => storage_path('logs/indiamart.log'),
                    ])->info('indiamart_crm Cron Job: Invalid mobile number ' . $vdata['mobile_no'] . '. Message not sent.');
                }
                /*Send WhatsApp Message End*/

                return response()->json(['status' => true, 'message' => 'Data Inserted Successfully'], 200);
            } else {
                return response()->json(['status' => false, 'message' => 'Data required'], 200);
            }
        } catch (\Exception $e) {
            Log::build([
                'driver' => 'single',
                'path' => storage_path('logs/indiamart.log'),
            ])->info(["India Mart Log push api error" => $e->getMessage()]);
            return response()->json(['status' => false, 'message' => 'Something went wrong while saving the data', 'error' => $e->getMessage()], 500);
        }
    }

    public function sendWhatsAppMessage($sendTo, $indiamart_user_id, $visitorId)
    {
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        $configs = DB::table('configs')->where('id', '1')->first();
        $template = Template::where('whatsapp_template_id', $configs->whatsapp_template_id)->first();
        // dd($whatsappConfig);
        if ($whatsappConfig && isset($configs) && $configs->whatsapp_template_id && $template) {
            $sendTestMessageUrl = 'https://graph.facebook.com/v21.0/' . $whatsappConfig->phone_id . '/messages';
            if ($template->file_type) {
                if ($template->file_type == 'image') {
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $sendTo,
                        "type" => "template",
                        "template" => [
                            "name" =>  $template->name,
                            "language" => [
                                "code" => "en"
                            ],
                            "components" => [
                                [
                                    "type" => "header",
                                    "parameters" => [
                                        [
                                            "type" => "image",
                                            "image" => [
                                                "id" => $template->whatsapp_file_id
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ];
                } else {
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $sendTo,
                        "type" => "template",
                        "template" => [
                            "name" =>  $template->name,
                            "language" => [
                                "code" => "en"
                            ],
                            "components" => [
                                [
                                    "type" => "header",
                                    "parameters" => [
                                        [
                                            "type" => "DOCUMENT",
                                            "document" => [
                                                "id" => $template->whatsapp_file_id
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ];
                }
            } else {
                $data = [
                    "messaging_product" => "whatsapp",
                    "to" => $sendTo,
                    "type" => "template",
                    "template" => [
                        "name" =>  $template->name,
                        "language" => [
                            "code" => "en"
                        ]
                    ]
                ];
            }
            $ch = curl_init($sendTestMessageUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $whatsappConfig->token
            ]);
            $sendTestMessageResponse = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $data = json_decode($sendTestMessageResponse, true);

            $sendTestMessageResponse = json_decode($sendTestMessageResponse);
            //dd($sendTestMessageResponse);
            if (isset($sendTestMessageResponse->error)) {
                return response()->json([
                    "status" => false,
                    "message" => $sendTestMessageResponse->error->message,
                    "response" => $sendTestMessageResponse
                ]);
            }

            // Check if the 'messages' key exists and has a valid value
            if (isset($data['messages']) && !empty($data['messages'][0])) {
                // Extract the necessary information
                $messageId = $data['messages'][0]['id'];
                $messageStatus = $data['messages'][0]['message_status'];

                // Get the wa_id from the contacts array
                $wa_id = $data['contacts'][0]['wa_id'] ?? null;

                // Prepare data for logging
                $requestData = [
                    'user_id' => $indiamart_user_id,
                    'visitor_id' => $visitorId,
                    'template_id' => $configs->whatsapp_template_id,
                    'mobile' => $wa_id ?? $sendTo,
                    'wamid' => $messageId,
                    'status' => $messageStatus,
                ];

                // Save to WhatsappLog only if the conditions are met
                WhatsappLog::create($requestData);
            }

            return response()->json([
                "status" => true,
                "message" => "Message send successfully",
                "response" => $sendTestMessageResponse
            ]);
        }
        return response()->json([
            "status" => false,
            "message" => "Configuration not found",
            "response" => null
        ]);
    }
}
