<?php

namespace App\Imports;

use App\Models\IssueMaster;
use App\Models\MachineCategory;
use App\Models\machinedetail;
use App\Models\MachineMaster;
use App\Models\Lead;
use Illuminate\Support\Facades\Session;

use Exception;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;

use Illuminate\Support\Collection;

use Maatwebsite\Excel\Concerns\ToCollection;

class CommonSessionImport implements ToCollection, WithHeadingRow, WithBatchInserts, WithChunkReading
{
    protected $sessionKey = "importData";
    public function __construct($sessionKey)
    {
        $this->sessionKey = $sessionKey;
    }

    public function collection(Collection $rows): void
    {
        // throw new Exception(json_encode($rows));
        Session::forget($this->sessionKey);

        Session::put($this->sessionKey, $rows);
    }

    public function batchSize(): int
    {
        return 1000;
    }

    public function chunkSize(): int
    {
        return 1000;
    }
}
