<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailBatchLog extends Model
{
    use HasFactory;

    protected $table = 'email_batch_logs';

    protected $fillable = [
        'batch_id','visitor_id','user_id','status'
    ];
    public static function getdata($batchid,$status){
        $query = EmailBatchLog::select('email_batch_logs.id','visitors.email','email_batch_logs.status')
        ->join('visitors', 'visitors.id', 'email_batch_logs.visitor_id')
        ->where('email_batch_logs.batch_id',$batchid);
        if($status != "all"){
            $query->where('email_batch_logs.status',$status);
        }
        return $query->orderBy('email_batch_logs.id');
    }
}
