<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
class Event extends Model
{
    use HasFactory, Notifiable;
    protected $table = "events";
    public $timestamps = false;
    protected $guarded = [];

    public function fetchAllUsers($search=null)
    {
        return Event::select('events.id', 'events.event_name', 'events.city', 'events.details', 'events.start_date', 'events.end_date', 'events.created_at', 'events.updated_at', 'events.type_show_all', 'event_assignments.is_admin')->leftjoin('event_assignments', 'event_assignments.fk_event_id', 'events.id')
            ->when($search,function($q)use($search){
                $q->where(function($q)use($search){
                    $q->where('events.event_name','like','%'.$search.'%')->orWhere('events.details','like','%'.$search.'%')->orWhere('events.city','like','%'.$search.'%');
                });
            })
            ->where('event_assignments.fk_user_id', Auth::user()->user_id)->orderBy('events.event_name', 'asc');
    }

    public static function countEvents()
    {
        return Event::count();
    }
    public static function insert_event_with_martkey($type,$indiamartkey)
    {
        if($type == 'india_mart'){
            $event_name = 'IndiaMart';
        }else{
            $event_name ='TradIndia';
        }
        $data =[
            'event_name' => $event_name,
            'start_date' => date('Y-m-d H:i:s'),
            'end_date' => date('Y-m-d H:i:s'),
            'created_at' => date('Y-m-d H:i:s'),
        ];
        return $query = Event::insert($data);
    }

    public function assignes_admins(){
        return $this->hasMany(EventAssignment::class, 'fk_event_id', 'id')->where('is_admin','true');
    }
}
