<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Str;

class Product extends Model
{
    use HasFactory, Notifiable;
    protected $table = "products";
    public $timestamps = false;

    public $guarded = [];
    public function fetchAllProduct()
    {
        return Product::select('users.user_id','product_images.image','products.*')
        ->leftjoin('users', 'users.user_id', 'products.fk_user_id')
        ->leftjoin('product_images', 'product_images.fk_product_id', 'products.id')
        ->groupBy('products.id')
        ->orderBy('products.id', 'desc');
    }
    public static function countProducts()
    {
        return Product::count();
    }
    public static function generateProductQr($id){
        $product = Product::find($id);
        if(!empty($product->product_code)){
            // $filename = $product->product_code.'.png';
            $filename = Str::slug($product->product_code).'.png';
            $dirPath = public_path('uploads/product_qr');
            $qr = QrCode::format('png')->size(900)
            ->margin(1)
            ->generate($product->product_code);
            // Create directory if it doesn't exist
            if (!File::isDirectory($dirPath)) {
                File::makeDirectory($dirPath, 0775, true);
                // OR: mkdir($dirPath, 0775, true);
            }
        
            // Full file path
            $filePath = $dirPath . '/' . $filename;
        
            // Save QR image
            file_put_contents($filePath, $qr);
        
            // Save relative path in DB (from public/uploads)
            $product->update([
                'qr_file' =>  $filename,
            ]);
            return $filename;
        }
        return false;
    }
}
