<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Template extends Model
{
    use HasFactory;

    protected $fillable = [
        'name','header','message','footer',
        'whatsapp_template_id','file_size_in_bytes',
        'file_mime_type','whatsapp_file_id',
        'file_type','file','status',
        'approved_at','created_by'
    ];

    protected $append = ['file_url','file_url_new'];

    public function getFileUrlAttribute()
    {
        return url('uploads/template/'.$this->id).'/'. $this->file;
    }

    public function getFileUrlNewAttribute()
    {
        return public_path('uploads/template/'.$this->id).'/'. $this->file;
    }


}
