<?php

namespace App\Models;

use Carbon\Carbon;
use DateTime;
use DateTimeZone;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLocation extends Model
{
    use HasFactory;
    protected $fillable = ['user_id', 'lat', 'lng', 'traveld_km', 'on_demand', 'date_time'];
    public $timestamps = false;

    protected $appends = ['user_location_time','display_time'];
    public function addRecode(array $data)
    {
        self::create($data);
    }

    public function getDisplayTimeAttribute()
    {
        $date_time = $this?->date_time;

        if(empty($date_time)){
            return null;
        }
        return Carbon::parse($date_time)->format('h:i A');
    }

    public function getUserLocationTimeAttribute()
    {
        $date_time = $this?->date_time;

        if (!empty($date_time)) {
            // Create DateTime objects with timezone
            $dt  = new DateTime($date_time, new DateTimeZone('Asia/Kolkata'));
            $now = new DateTime('now', new DateTimeZone('Asia/Kolkata'));

            $diff = $now->getTimestamp() - $dt->getTimestamp(); // difference in seconds

            if ($diff < 0) {
                return "Just now"; // future dates
            }

            $days    = floor($diff / 86400);
            $hours   = floor(($diff % 86400) / 3600);
            $minutes = floor(($diff % 3600) / 60);
            $seconds = $diff % 60;

            $parts = [];
            if ($days > 0) {
                $parts[] = $days . ' Day' . ($days > 1 ? 's' : '');
            }
            if ($hours > 0) {
                $parts[] = $hours . ' Hr' . ($hours > 1 ? 's' : '');
            }
            if ($minutes > 0) {
                $parts[] = $minutes . ' Min';
            }
            if ($seconds > 0) {
                $parts[] = $seconds . ' Sec';
            }

            // Pick top 2 largest units
            $parts = array_slice($parts, 0, 2);

            return implode(' ', $parts) . ' ago';
        }

        return null;
    }
}
