<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;

class Visitor extends Model
{
    use HasFactory;
    protected $table = "visitors";
    public $timestamps = false;
    protected $guarded = ['id'];

    public static function fetchAllvisitor($eventid, $CustomerID, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $action = null, $follow_up_time = null, $sourceoflead = null, $area = null)
    {

        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*', 'permissions.send_email as email_permission')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->leftJoin('permissions', 'permissions.fk_customer_id', 'visitors.customer_id');
        // ->orderBy('events.event_name', 'asc');


        // $event_check = DB::table('events')->where
        if ($eventid != "all") {
            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });
        }

        if ($CustomerID != "all") {
            $query = $query->where('CustomerID', $CustomerID);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', '=', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', '=', $cityId);
        }

        if ($area != "all" && $area != null) {
            $query = $query->where('visitors.area', '=', $area);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($action != "all" && $action != null) {
            $query = $query->where('visitors.action', $action);
        }

        if ($countryId != "all" && $countryId != null) {

            $countryISOCode = DB::table('countries')->where('name', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);

        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            //dd($startDateFormatted);
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }


        if ($sourceoflead != "all" && $sourceoflead != null) {
            $query = $query->where('visitors.source_of_lead', $sourceoflead);
        }

        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');
    }
    public static function fetchAllvisitorMultipleSelection($eventids, $CustomerIDs, $categoryIds = [], $subCategoryIds = [], $stateIds = [], $cityIds = [], $isInternational = null, $countryIds = [], $regions = [], $startDate = null, $endDate = null, $actions = [], $follow_up_time = null, $sourceofleads = [], $areas = [])
    {

        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*', 'permissions.send_email as email_permission')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->leftJoin('permissions', 'permissions.fk_customer_id', 'visitors.customer_id');
        // ->orderBy('events.event_name', 'asc');


        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            $query = $query->whereIn('visitors.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            //dd($startDateFormatted);
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }


        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }

        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');
    }
    public static function countVisitors()
    {
        $authAdmin = auth()->user();
        $result = Visitor::select('users.CustomerName', 'visitors.*')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id');
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $result = $result->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $result =  $result->groupBy('visitors.id')->get();
        return count($result);
    }

    public static function getvisitorByFilterExport($event_id, $customer_id, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $sourceoflead = null, $area = null)
    {
        //DB::enableQueryLog();
        // $query= DB:: table('visitors')
        // ->select('visitor_products.product_id','visitors.*', DB::raw("GROUP_CONCAT(products.name) as product_name"))
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        // ->groupBy('visitor_products.visitor_id');


        // $query = Visitor::select('products.name as product_name','visitor_products.product_id','visitors.*')
        // ->join('events', 'events.id', 'visitors.event_id')
        // ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        // ->orderBy('visitors.id', 'desc');
        $query = Visitor::select(
            'visitors.id',
            'visitors.visited_date',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.pincode',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.area',
            'visitors.email2',
            'visitors.category',
            'visitors.sub_category',
            'visitors.remarks',
            'visitors.action',
            'visitors.source_of_lead',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'visitors.lat',
            'visitors.lng',
            'visitors.source_of_lead',
            'countries.name as country_name',
            'region.name as region_name',
            'events.event_name as event_name',
            'users.CustomerName as teamName',
            DB::raw('GROUP_CONCAT(products.name) as product_names')
        )
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->leftjoin('countries', 'countries.iso_code', 'visitors.country_code')
            ->leftjoin('region_country', 'region_country.fk_country_id', 'countries.id')
            ->leftjoin('region', 'region.id', 'region_country.fk_region_id')
            ->orderBy('visitors.id', 'desc');

        if ($event_id != "all") {
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('event_id', $event_id)
                    ->orWhereRaw('FIND_IN_SET(?, visitors.event_ids)', [$event_id]);
            });
        }
        if ($customer_id != "all") {
            $query = $query->where('CustomerID', $customer_id);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }
        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->whereRaw('FIND_IN_SET(? , visitors.category)', [$categoryName]);
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            //$stateName = DB::table('states')->where('id', $stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            /*$cityName = DB::table('cities')->where('id', $cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', $cityName);*/
            $query = $query->where('visitors.city', '=', $cityId);
        }
        if ($area != "all" && $area != null) {
            $query = $query->where('visitors.area', '=', $area);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {

            $countryISOCode = DB::table('countries')->where('name', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);

        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }

        if ($sourceoflead != "all" && $sourceoflead != null) {
            $query = $query->where('visitors.source_of_lead', $sourceoflead);
        }

        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id')->get();
    }
    public static function getvisitorByFilterExportMultiple($eventids, $CustomerIDs, $categoryIds = null, $subCategoryIds = null, $stateIds = null, $cityIds = null, $isInternational = null, $countryIds = null, $regions = null, $startDate = null, $endDate = null, $sourceofleads = null, $areas = null, $actions = null)
    {

        $query = Visitor::select(
            'visitors.id',
            'visitors.visited_date',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.pincode',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.area',
            'visitors.email2',
            'visitors.category',
            'visitors.sub_category',
            'visitors.remarks',
            'visitors.action',
            'visitors.source_of_lead',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'visitors.lat',
            'visitors.lng',
            'visitors.source_of_lead',
            'countries.name as country_name',
            'region.name as region_name',
            'events.event_name as event_name',
            'users.CustomerName as teamName',
            DB::raw('GROUP_CONCAT(products.name) as product_names')
        )
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->leftjoin('countries', 'countries.iso_code', 'visitors.country_code')
            ->leftjoin('region_country', 'region_country.fk_country_id', 'countries.id')
            ->leftjoin('region', 'region.id', 'region_country.fk_region_id')
            ->orderBy('visitors.id', 'desc');





        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            $query = $query->whereIn('visitors.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            //dd($startDateFormatted);
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }


        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }


        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id')->get();
    }

    public static function getCountryName($country_code)
    {
        $country = DB::table('countries')->where('iso_code',$country_code)->select('name', 'id')->first();
        $name = '-';
        if ($country) {
            $name = $country->name;
        }
        return $name;
    }

    public static function fetchEmailVisitors($eventid, $CustomerID, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $action = null, $area = null)
    {
        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->orderBy('visitors.id', 'desc')
            ->where('visitors.email', '!=', '')
            ->where('visitors.email', '!=', null);


        // $event_check = DB::table('events')->where
        if ($eventid != "all") {
            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });
        }

        if ($CustomerID != "all") {
            $query = $query->where('CustomerID', $CustomerID);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            //$stateName = DB::table('states')->where('id', $stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', '=', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            /*$cityName = DB::table('cities')->where('id', $cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', '=', $cityName);*/
            $query = $query->where('visitors.city', '=', $cityId);
        }
        if ($area != "all" && $area != null) {
            $query = $query->where('visitors.area', '=', $area);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {
            $countryISOCode = DB::table('countries')->where('id', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }

        if ($action !== null && $action !== 'all') {
            $query->where('visitors.action', $action);
        }
        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');
    }

    public static function fetchEmailVisitorsMultipleSelection($eventids, $CustomerIDs, $categoryIds = [], $subCategoryIds = [], $stateIds = [], $cityIds = [], $isInternational = null, $countryIds = null, $regions = null, $startDate = null, $endDate = null, $actions = [], $areas = null, $sourceofleads = null)
    {
        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->orderBy('visitors.id', 'desc')
            ->where('visitors.email', '!=', '')
            ->where('visitors.email', '!=', null);



        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            $query = $query->whereIn('visitors.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            //dd($startDateFormatted);
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }


        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }

        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');
    }

    public static function fetchBulkMessageVisitors($eventid, $CustomerID, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $action = null, $area = null)
    {
        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->orderBy('visitors.id', 'desc');
        $query = $query->where(function ($query) {
            $query->where('visitors.mobile_no', '!=', '')
                ->orWhere('visitors.mobile_no', '!=', null);
        });

        // $event_check = DB::table('events')->where
        if ($eventid != "all") {
            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });
        }

        if ($CustomerID != "all") {
            $query = $query->where('CustomerID', $CustomerID);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            //$stateName = DB::table('states')->where('id', $stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', '=', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            /*$cityName = DB::table('cities')->where('id', $cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', '=', $cityName);*/
            $query = $query->where('visitors.city', '=', $cityId);
        }
        if ($area != "all" && $area != null) {
            $query = $query->where('visitors.area', '=', $area);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {
            $countryISOCode = DB::table('countries')->where('id', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }

        if ($action !== null && $action !== 'all') {
            $query->where('visitors.action', $action);
        }
        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');
    }

    public static function fetchBulkMessageVisitorsMultipleSelection($eventids, $CustomerIDs, $categoryIds = [], $subCategoryIds = [], $stateIds = [], $cityIds = [], $isInternational = null, $countryIds = null, $regions = null, $startDate = null, $endDate = null, $actions = null, $areas = null, $sourceofleads = null)
    {
        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->orderBy('visitors.id', 'desc');
        $query = $query->where(function ($query) {
            $query->where('visitors.mobile_no', '!=', '')
                ->orWhere('visitors.mobile_no', '!=', null);
        });


        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            $query = $query->whereIn('visitors.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            //dd($startDateFormatted);
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }


        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }
        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');
    }

    public static function fetchAllVisitorByEvent(
        $eventid = null,
        $categoryId = null,
        $subCategoryId = null,
        $stateId = null,
        $cityId = null,
        $isInternational = null,
        $countryId = null,
        $startDate = null,
        $endDate = null,
        $action = null,
        $follow_up_time = null,
        $follow_up_start_date = null,
        $follow_up_end_date = null,
        $sourceoflead = null
    ) {
        DB::enableQueryLog();

        $user_id = Auth::user()->user_id;
        $userdetail = Auth::user()->getUser();
        $currentUserCustomerId = $userdetail->CustomerID;

        // Base query for Visitor model
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visitors.customer_id');

        if ($eventid === 'all') {
            // Apply complex filtering for assigned events and admin status
            $query->where(function ($query) use ($user_id, $currentUserCustomerId) {
                $query->whereIn('visitors.event_id', function ($innerQuery) use ($user_id) {
                    $innerQuery->select('fk_event_id')
                        ->from('event_assignments')
                        ->where('fk_user_id', $user_id);
                })
                    ->where(function ($subQuery) use ($user_id, $currentUserCustomerId) {
                        $subQuery->whereIn('visitors.event_id', function ($innerSubQuery) use ($user_id) {
                            $innerSubQuery->select('fk_event_id')
                                ->from('event_assignments')
                                ->where('fk_user_id', $user_id)
                                ->where('is_admin', 'true');
                        })
                            ->orWhere(function ($subSubQuery) use ($currentUserCustomerId) {
                                $subSubQuery->where('visitors.customer_id', $currentUserCustomerId);
                            });
                    });
            });
        } else if ($eventid !== null) {
            // Filter by specific event id

            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });

            $eventsdata = DB::table('event_assignments')->where('fk_user_id', $user_id)->where('fk_event_id', $eventid)->first();

            if ($eventsdata->is_admin == "true") {
                //dd($eventsdata);
            } else {
                $query->where('users.CustomerID', $userdetail->CustomerID);
            }
        }

        // Apply additional filters based on parameters
        if ($categoryId !== null && $categoryId !== 'all') {
            $categoryName = DB::table('category')->where('id', $categoryId)->value('name');
            $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
        }

        if ($subCategoryId !== null && $subCategoryId !== 'all') {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->value('name');
            $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
        }

        if ($stateId !== null && $stateId !== 'all') {
            //$stateName = DB::table('states')->where('id', $stateId)->value('name');
            $query->where('visitors.state', '=', $stateId);
        }

        if ($cityId !== null && $cityId !== 'all') {
            //$cityName = DB::table('cities')->where('id', $cityId)->value('name');
            $query->where('visitors.city', 'LIKE', $cityId);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId !== null && $countryId !== 'all') {
            $countryISOCode = DB::table('countries')->where('id', $countryId)->value('iso_code');
            $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($startDate !== null && $endDate !== null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
        }

        if ($action !== null && $action !== 'all') {
            $query->where('visitors.action', $action);
        }

        // Handle follow_up_time logic

        if ($follow_up_time == 'today') {
            if ($follow_up_start_date != null && $follow_up_start_date != "" && $follow_up_end_date != null && $follow_up_end_date != "") {
                $followupstartDateFormatted = date('Y-m-d', strtotime($follow_up_start_date));
                $followupendDateFormatted = date('Y-m-d', strtotime($follow_up_end_date));
                //dd($followupstartDateFormatted);
                $query = $query->where(function ($query) use ($followupstartDateFormatted, $followupendDateFormatted) {
                    $query->whereDate('visitors.follow_up_time', '>=', $followupstartDateFormatted)
                        ->whereDate('visitors.follow_up_time', '<=', $followupendDateFormatted);
                });
                /*$query->whereDate('visitors.follow_up_time', '>=', $followupstartDateFormatted)
                    ->whereDate('visitors.follow_up_time', '<=', $followupendDateFormatted);*/
            } else {
                $now = date('Y-m-d');
                $query->whereDate('visitors.follow_up_time', $now)
                    ->whereTime('visitors.follow_up_time', '!=', date('H:m:s'));
            }
        } elseif ($follow_up_time == 'past') {
            if (!empty($follow_up_start_date) && !empty($follow_up_end_date)) {
                $followupStartDate = date('Y-m-d', strtotime($follow_up_start_date));
                $followupEndDate = date('Y-m-d', strtotime($follow_up_end_date));

                $query->whereDate('visitors.follow_up_time', '>=', $followupStartDate)
                    ->whereDate('visitors.follow_up_time', '<=', $followupEndDate);
                //   ->whereTime('visitors.follow_up_time', '!=', '00:00:00');
            } else {
                // If no start or end date is provided, handle the case
                $now = date('Y-m-d H:i:s');
                $query->whereDate('visitors.follow_up_time', '<', $now)
                    ->whereTime('visitors.follow_up_time', '!=', '00:00:00');
            }
        }
        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->where('visitors.visited_date', '>=', $startDateFormatted)
                    ->where('visitors.visited_date', '<=', $endDateFormatted);
            });
        }

        if ($sourceoflead !== null && $sourceoflead !== 'all') {
            $query->where('visitors.source_of_lead', $sourceoflead);
        }

        // Order and group the results
        return $query->orderBy('visitors.id', 'desc')->groupBy('visitors.id');
    }


    public static function getvisitorByEventFilterExport($event_id, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $action = null, $startDate = null, $endDate = null, $sourceoflead = null)
    {
        //DB::enableQueryLog();

        $query = Visitor::select(
            'visitors.id',
            'visitors.visited_date',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.area',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.email2',
            'visitors.category',
            'visitors.sub_category',
            'visitors.remarks',
            'visitors.action',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'visitors.source_of_lead',
            'countries.name as country_name',
            'region.name as region_name',
            'events.event_name as event_name',
            'users.CustomerName as teamName',
            DB::raw('GROUP_CONCAT(products.name) as product_names')
        )
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->leftjoin('countries', 'countries.iso_code', 'visitors.country_code')
            ->leftjoin('region_country', 'region_country.fk_country_id', 'countries.id')
            ->leftjoin('region', 'region.id', 'region_country.fk_region_id')
            ->orderBy('visitors.id', 'desc');

        if ($event_id != "all") {
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('event_id', $event_id)
                    ->orWhereRaw('FIND_IN_SET(?, visitors.event_ids)', [$event_id]);
            });
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->whereRaw('FIND_IN_SET(? , visitors.category)', [$categoryName]);
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            //$stateName = DB::table('states')->where('id', $stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            /*$cityName = DB::table('cities')->where('id', $cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', $cityName);*/
            $query = $query->where('visitors.city', '=', $cityId);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {
            //dd($countryId);
            $countryISOCode = DB::table('countries')->where('id', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);
        }
        if ($action != "all" && $action != null) {
            $query = $query->where('visitors.action', $action);
        }


        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
        }
        if ($sourceoflead !== null && $sourceoflead !== 'all') {
            $query->where('visitors.source_of_lead', $sourceoflead);
        }
        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id')->get();
    }

    public static function fetchEmailVisitorsByEvent($eventid, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $startDate = null, $endDate = null, $action = null)
    {
        DB::enableQueryLog();

        $user_id = Auth::user()->user_id;
        $userdetail = Auth::user()->getUser();
        $currentUserCustomerId = $userdetail->CustomerID;

        // Base query for Visitor model
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visitors.customer_id');

        if ($eventid === 'all') {
            // Apply complex filtering for assigned events and admin status
            $query->where(function ($query) use ($user_id, $currentUserCustomerId) {
                $query->whereIn('visitors.event_id', function ($innerQuery) use ($user_id) {
                    $innerQuery->select('fk_event_id')
                        ->from('event_assignments')
                        ->where('fk_user_id', $user_id);
                })
                    ->where(function ($subQuery) use ($user_id, $currentUserCustomerId) {
                        $subQuery->whereIn('visitors.event_id', function ($innerSubQuery) use ($user_id) {
                            $innerSubQuery->select('fk_event_id')
                                ->from('event_assignments')
                                ->where('fk_user_id', $user_id)
                                ->where('is_admin', 'true');
                        })
                            ->orWhere(function ($subSubQuery) use ($currentUserCustomerId) {
                                $subSubQuery->where('visitors.customer_id', $currentUserCustomerId);
                            });
                    });
            });
        } else if ($eventid !== null) {
            // Filter by specific event id

            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });

            $eventsdata = DB::table('event_assignments')->where('fk_user_id', $user_id)->where('fk_event_id', $eventid)->first();

            if ($eventsdata->is_admin == "true") {
                //dd($eventsdata);
            } else {
                $query->where('users.CustomerID', $userdetail->CustomerID);
            }
        }

        // Apply additional filters based on parameters
        if ($categoryId !== null && $categoryId !== 'all') {
            $categoryName = DB::table('category')->where('id', $categoryId)->value('name');
            $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
        }

        if ($subCategoryId !== null && $subCategoryId !== 'all') {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->value('name');
            $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
        }

        if ($stateId !== null && $stateId !== 'all') {
            //$stateName = DB::table('states')->where('id', $stateId)->value('name');
            $query->where('visitors.state', '=', $stateId);
        }

        if ($cityId !== null && $cityId !== 'all') {
            //$cityName = DB::table('cities')->where('id', $cityId)->value('name');
            $query->where('visitors.city', 'LIKE', $cityId);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId !== null && $countryId !== 'all') {
            $countryISOCode = DB::table('countries')->where('id', $countryId)->value('iso_code');
            $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($startDate !== null && $endDate !== null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
        }

        if ($action !== null && $action !== 'all') {
            $query->where('visitors.action', $action);
        }

        // Order and group the results
        return $query->orderBy('visitors.id', 'desc')->groupBy('visitors.id');
    }

    public static function fetchClientAllvisitor($eventid, $CustomerID, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $action = null, $follow_up_time = null, $product = null, $area = null)
    {

        DB::enableQueryLog();
        $query = VisitData::select('visit_data.id', 'visit_data.action as visit_action', 'visit_data.remarks as visit_remarks', 'visit_data.fk_visitor_id', 'visit_data.follow_up_time as visit_follow_up_time', 'visit_data.visit_time', 'users.CustomerName', 'visitors.id as visitors_id', 'visitors.name', 'visitors.company_name', 'visitors.mobile_no', 'visitors.email', 'events.event_name', 'visitors.event_ids')
            ->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');

        // $event_check = DB::table('events')->where
        if ($eventid != "all") {
            $query = $query->where(function ($query) use ($eventid) {
                $query->where('visitors.event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });
        }

        if ($CustomerID != "all") {
            $query = $query->where('visit_data.fk_teammember_id', $CustomerID);
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', '=', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', '=', $cityId);
        }
        if ($area != "all" && $area != null) {
            $query = $query->where('visitors.area', '=', $area);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($action != "all" && $action != null) {
            $query = $query->where('visit_data.action', $action);
        }

        if ($countryId != "all" && $countryId != null) {
            $countryISOCode = DB::table('countries')->where('id', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                    ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
            });
        }

        if ($product != "all" && $product != null) {
            //$query = $query->where('visit_data.action', $action);
            $query->whereHas('products', function ($query) use ($product) {
                $query->where(function ($query) use ($product) {
                    foreach ($product as $p) {
                        $query->orWhere('fk_product_id', '=', $p);
                    }
                });
            });
        }
        //dd(DB::getQuerylog($query->get()));
        return $query;
    }

    public static function fetchClientAllvisitorMultipleSelection($eventids, $CustomerIDs = [], $categoryIds = null, $subCategoryIds = null, $stateIds = null, $cityIds = null, $isInternational = null, $countryIds = null, $regions = null, $startDate = null, $endDate = null, $actions = null, $follow_up_time = null, $product = null, $areas = null, $sourceofleads = null)
    {
        // $eventids, $CustomerIDs, $categoryIds = [], $subCategoryIds = [], $stateIds = [], $cityIds = [], $isInternational = null, $countryIds = [], $regions = [], $startDate = null, $endDate = null, $actions = [], $follow_up_time = null, $sourceofleads = [], $areas = []
        DB::enableQueryLog();
        $query = VisitData::select('visit_data.id', 'visit_data.action as visit_action', 'visit_data.remarks as visit_remarks', 'visit_data.fk_visitor_id', 'visit_data.follow_up_time as visit_follow_up_time', 'visit_data.visit_time', 'users.CustomerName', 'visitors.id as visitors_id', 'visitors.name', 'visitors.company_name', 'visitors.mobile_no', 'visitors.email', 'events.event_name', 'visitors.event_ids')
            ->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');

        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            // $query = $query->whereIn('visitors.action', $actions);
            $query = $query->whereIn('visit_data.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                    ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
            });
        }



        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }
        if ($product != "all" && $product != null) {
            //$query = $query->where('visit_data.action', $action);
            $query->whereHas('products', function ($query) use ($product) {
                $query->where(function ($query) use ($product) {
                    foreach ($product as $p) {
                        $query->orWhere('fk_product_id', '=', $p);
                    }
                });
            });
        }
        //dd(DB::getQuerylog($query->get()));
        return $query;
    }

    public static function getclientvisitorByFilterExport($event_id, $customer_id, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $action = null, $product = null, $area = null)
    {

        $query = VisitData::select(
            //'visitors.id',
            'visit_data.id',
            'visit_data.visit_time',
            'visit_data.follow_up_time as visit_follow_up_time',
            'visit_data.fk_visitor_id',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.country_code',
            'visitors.pincode',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.area',
            'visitors.email',
            'visitors.email2',
            'visitors.lat',
            'visitors.lng',
            'visitors.category',
            'visitors.sub_category',
            'visit_data.remarks as visit_remarks',
            'visit_data.action as visit_action',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'users.CustomerName as teamName',
            'events.event_name',
            'visitors.event_ids',
            'visitors.source_of_lead'
        )
            ->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');

        if ($event_id != "all") {
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('visitors.event_id', $event_id)
                    ->orWhereRaw('FIND_IN_SET(?, visitors.event_ids)', [$event_id]);
            });
        }
        if ($customer_id != "all") {
            $query = $query->where('visit_data.fk_teammember_id', $customer_id);
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->whereRaw('FIND_IN_SET(? , visitors.category)', [$categoryName]);
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            //$stateName = DB::table('states')->where('id', $stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            /* $cityName = DB::table('cities')->where('id', $cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', $cityName);*/
            $query = $query->where('visitors.city', '=', $cityId);
        }
        if ($area != "all" && $area != null) {
            $query = $query->where('visitors.area', '=', $area);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }
        if ($action != "all" && $action != null) {
            $query = $query->where('visit_data.action', $action);
        }

        if ($countryId != "all" && $countryId != null) {
            $countryISOCode = DB::table('countries')->where('id', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                    ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
            });
        }
        if ($product != "all" && $product != null) {
            //$query = $query->where('visit_data.action', $action);
            $query->whereHas('products', function ($query) use ($product) {
                $query->where(function ($query) use ($product) {
                    foreach ($product as $p) {
                        $query->orWhere('fk_product_id', '=', $p);
                    }
                });
            });
        }
        //dd(DB::getQuerylog($query->get()));
        $data = $query->get();
        //dd($data);

        foreach ($data as $obj) {
            $eventIds = explode(',', $obj->event_ids);
            $eventIds = array_filter($eventIds, function ($id) use ($event_id) {
                return $id != $event_id;
            });
            $eventIds = array_values($eventIds);
            $eventNames = [];
            if (!empty($eventIds)) {
                $eventNames = DB::table('events')->whereIn('id', $eventIds)->pluck('event_name')->toArray();
            }
            $eventNamesString = implode(', ', $eventNames);
            $obj->eventNames = $eventNamesString;
        }

        //return $query->get();
        return $data;
    }

    public static function getclientvisitorByFilterExportMultipleSelection($eventids, $CustomerIDs = [], $categoryIds = null, $subCategoryIds = null, $stateIds = null, $cityIds = null, $isInternational = null, $countryIds = null, $regions = null, $startDate = null, $endDate = null, $actions = null, $product = null, $areas = null, $sourceofleads = null)
    {
        //$event_id, $customer_id, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $action = null, $product = null, $area = null
        $query = VisitData::select(
            //'visitors.id',
            'visit_data.id',
            'visit_data.visit_time',
            'visit_data.follow_up_time as visit_follow_up_time',
            'visit_data.fk_visitor_id',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.country_code',
            'visitors.pincode',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.area',
            'visitors.email',
            'visitors.email2',
            'visitors.lat',
            'visitors.lng',
            'visitors.category',
            'visitors.sub_category',
            'visit_data.remarks as visit_remarks',
            'visit_data.action as visit_action',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'users.CustomerName as teamName',
            'events.event_name',
            'visitors.event_ids',
            'visitors.source_of_lead'
        )
            ->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');

        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            // $query = $query->whereIn('visitors.action', $actions);
            $query = $query->whereIn('visit_data.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                    ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
            });
        }



        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }
        if ($product != "all" && $product != null) {
            //$query = $query->where('visit_data.action', $action);
            $query->whereHas('products', function ($query) use ($product) {
                $query->where(function ($query) use ($product) {
                    foreach ($product as $p) {
                        $query->orWhere('fk_product_id', '=', $p);
                    }
                });
            });
        }
        //dd(DB::getQuerylog($query->get()));
        $data = $query->get();
        //dd($data);

        foreach ($data as $obj) {
            $eventIds = explode(',', $obj->event_ids);
            $event_id = $obj?->event_id ?? 0;
            $eventIds = array_filter($eventIds, function ($id) use ($event_id) {
                return $id != $event_id;
            });
            $eventIds = array_values($eventIds);
            $eventNames = [];
            if (!empty($eventIds)) {
                $eventNames = DB::table('events')->whereIn('id', $eventIds)->pluck('event_name')->toArray();
            }
            $eventNamesString = implode(', ', $eventNames);
            $obj->eventNames = $eventNamesString;
        }

        //return $query->get();
        return $data;
    }

    public static function getclientvisitExport()
    {
        $query = VisitData::select(
            //'visitors.id',
            'visit_data.id',
            'visit_data.visit_time',
            'visit_data.follow_up_time as visit_follow_up_time',
            'visit_data.fk_visitor_id',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.area',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.email2',
            'visitors.lat',
            'visitors.lng',
            'visitors.category',
            'visitors.sub_category',
            'visit_data.remarks as visit_remarks',
            'visit_data.action as visit_action',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'users.CustomerName as teamName',
            'events.event_name',
            'visitors.event_ids',
            'visitors.source_of_lead'
        )->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');

        $currentdate = date('Y-m-d');
        $query = $query->where(function ($query) use ($currentdate) {
            $query->whereDate('visit_data.visit_time', '=', $currentdate);
        });
        $data = $query->get();
        foreach ($data as $obj) {
            $eventIds = explode(',', $obj->event_ids);
            $eventIds = array_filter($eventIds, function ($id) {
                return $id;
            });
            $eventIds = array_values($eventIds);
            $eventNames = [];
            if (!empty($eventIds)) {
                $eventNames = DB::table('events')->whereIn('id', $eventIds)->pluck('event_name')->toArray();
            }
            $eventNamesString = implode(', ', $eventNames);
            $obj->eventNames = $eventNamesString;
        }
        return $data;
    }


    public static function getGoogleContactByFilterExport($event_id, $customer_id, $categoryId = null, $subCategoryId = null, $stateId = null, $cityId = null, $isInternational = null, $countryId = null, $region = null, $startDate = null, $endDate = null, $sourceoflead = null)
    {

        //DB::enableQueryLog();
        // $query= DB:: table('visitors')
        // ->select('visitor_products.product_id','visitors.*', DB::raw("GROUP_CONCAT(products.name) as product_name"))
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        // ->groupBy('visitor_products.visitor_id');


        // $query = Visitor::select('products.name as product_name','visitor_products.product_id','visitors.*')
        // ->join('events', 'events.id', 'visitors.event_id')
        // ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        // ->orderBy('visitors.id', 'desc');
        $query = Visitor::select(
            'visitors.id',
            'visitors.visited_date',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.email2',
            'visitors.category',
            'visitors.sub_category',
            'visitors.remarks',
            'visitors.action',
            'visitors.source_of_lead',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'visitors.lat',
            'visitors.lng',
            'countries.name as country_name',
            'region.name as region_name',
            'events.event_name as event_name',
            'users.CustomerName as teamName',
            DB::raw('GROUP_CONCAT(products.name) as product_names')
        )
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->leftjoin('countries', 'countries.iso_code', 'visitors.country_code')
            ->leftjoin('region_country', 'region_country.fk_country_id', 'countries.id')
            ->leftjoin('region', 'region.id', 'region_country.fk_region_id')
            ->orderBy('visitors.id', 'desc');

        if ($event_id != "all") {
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('event_id', $event_id)
                    ->orWhereRaw('FIND_IN_SET(?, visitors.event_ids)', [$event_id]);
            });
        }
        if ($customer_id != "all") {
            $query = $query->where('CustomerID', $customer_id);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }
        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id', $categoryId)->select('name', 'id')->first()->name;
            $query = $query->whereRaw('FIND_IN_SET(? , visitors.category)', [$categoryName]);
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id', $subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            //$stateName = DB::table('states')->where('id', $stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', $stateId);
        }

        if ($cityId != "all" && $cityId != null) {
            /*$cityName = DB::table('cities')->where('id', $cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', $cityName);*/
            $query = $query->where('visitors.city', '=', $cityId);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {
            $countryISOCode = DB::table('countries')->where('name', $countryId)->select('iso_code', 'name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=', $countryISOCode);
        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id', $region)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }

        if ($sourceoflead != "all" && $sourceoflead != null) {
            $query = $query->where('visitors.source_of_lead', $sourceoflead);
        }

        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id')->get();
    }

    public static function fetchDashboardClientAllvisitor($CustomerID,  $startDate = null, $endDate = null, $action = null)
    {

        DB::enableQueryLog();
        $query = VisitData::select('visit_data.id', 'visit_data.action as visit_action', 'visit_data.remarks as visit_remarks', 'visit_data.fk_visitor_id', 'visit_data.follow_up_time as visit_follow_up_time', 'visit_data.visit_time', 'users.CustomerName', 'visitors.id as visitors_id', 'visitors.name', 'visitors.company_name', 'visitors.mobile_no', 'visitors.email', 'events.event_name', 'visitors.event_ids')
            ->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');



        if ($CustomerID != "all") {
            $query = $query->where('visit_data.fk_teammember_id', $CustomerID);
        }

        if ($action != "all" && $action != null) {
            $query = $query->where('visit_data.action', $action);
        }
        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                    ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
            });
        }
        //dd(DB::getQuerylog($query->get()));
        return $query;
    }
    public static function getClientDashboardVisitorslistExport($customer_id, $startDate = null, $endDate = null, $action = null)
    {

        $query = VisitData::select(
            //'visitors.id',
            'visit_data.id',
            'visit_data.visit_time',
            'visit_data.follow_up_time as visit_follow_up_time',
            'visit_data.fk_visitor_id',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.email2',
            'visitors.lat',
            'visitors.lng',
            'visitors.category',
            'visitors.sub_category',
            'visit_data.remarks as visit_remarks',
            'visit_data.action as visit_action',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'users.CustomerName as teamName',
            'events.event_name',
            'visitors.event_ids',
            'visitors.source_of_lead'
        )
            ->with('products')
            ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', 'visitors.event_id')
            ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
            ->orderBy('visit_data.id', 'desc');


        if ($customer_id != "all") {
            $query = $query->where('visit_data.fk_teammember_id', $customer_id);
        }


        if ($action != "all" && $action != null) {
            $query = $query->where('visit_data.action', $action);
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                    ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
            });
        }

        //dd(DB::getQuerylog($query->get()));
        $data = $query->get();
        //dd($data);

        foreach ($data as $obj) {
            $eventIds = explode(',', $obj->event_ids);
            /*$eventIds = array_filter($eventIds, function($id) use ($event_id) {
                return $id != $event_id;
            });*/
            $eventIds = array_values($eventIds);
            $eventNames = [];
            if (!empty($eventIds)) {
                $eventNames = DB::table('events')->whereIn('id', $eventIds)->pluck('event_name')->toArray();
            }
            $eventNamesString = implode(', ', $eventNames);
            $obj->eventNames = $eventNamesString;
        }

        //return $query->get();
        return $data;
    }

    public function visits()
    {
        return $this->hasMany(VisitData::class, 'fk_visitor_id');
    }
}
