<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Blade::directive('sessionContactField', function ($expression) {
            return "<?php \$contactFieldValue = session('contact_detail_fields.' . {$expression}); if (
            empty(\$contactFieldValue) ||
            !isset(\$contactFieldValue['hide']) ||
            (\$contactFieldValue['hide'] === false)
        ):  ?>";
        });

        Blade::directive('endsessionContactField', function () {
            return "<?php endif; unset(\$contactFieldValue); ?>";
        });

        Blade::directive('defaultValue', function ($expression) {
            return "<?php echo {$expression}; ?>";
        });
        Blade::directive('required', function ($expression) {
            return "<?php echo ($expression) ? 'required' : ''; ?>";
        });

        Blade::directive('requiredStart',function($expression){
            return "<?php echo ($expression) ? '<span class=\"text-danger\">*</span>' : ''; ?>";
        });
        Blade::directive('selected', function ($expression) {
            return "<?php echo ($expression) ? 'selected' : ''; ?>";
        });
    }
}
