<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailBatchTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_batch', function (Blueprint $table) {
            $table->id();
            $table->integer('created_by')->nullable();
            $table->string('email_type')->nullable();
            $table->integer('email_draft_id')->nullable();
            $table->integer('hour_interval_mails')->nullable();
            $table->integer('last_id_sent')->default(0);
            $table->enum('status', ['pending', 'sent'])->nullable();
            $table->datetime('schedule_date')->default(now());
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email_batch');
    }
}
