<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visit_data', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('fk_teammember_id')->unsigned();
            $table->bigInteger('fk_visitor_id')->unsigned();
            $table->string('action', 225)->nullable();
            // $table->string('remarks', 225)->nullable();
            $table->text('remarks')->nullable();
            $table->timestamp('follow_up_time')->nullable();
            $table->string('audio_file', 225)->nullable();
            $table->string('location', 225)->nullable();
            $table->timestamps();
            $table->string('lat', 255)->nullable();
            $table->string('lng', 255)->nullable();
            $table->timestamp('visit_time')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visit_data');
    }
}
