<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permissions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('fk_customer_id');
            $table->enum('Contact_Share', ['0', '1'])->default('0');
            $table->enum('Call_Contact', ['0', '1'])->default('0');
            $table->enum('Send_Whatsapp', ['0', '1'])->default('0');
            $table->enum('Save_Contact', ['0', '1'])->default('0');
            $table->enum('Export_Excel', ['0', '1'])->default('0');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->enum('send_email', ['0', '1'])->default('0');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permissions');
    }
}
