<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitDataProductTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visit_data_product', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('fk_visit_data_id');
            $table->unsignedBigInteger('fk_product_id');
            
            // Foreign key constraints
            $table->foreign('fk_visit_data_id')->references('id')->on('visit_data')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('fk_product_id')->references('id')->on('products')->onDelete('cascade')->onUpdate('cascade');

            // Add any additional columns or constraints here

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visit_data_product');
    }
}
