<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('templates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('created_by');

            $table->string('whatsapp_template_id', 255)->nullable();
            $table->string('whatsapp_file_id', 255)->nullable();
            $table->string('name', 255)->nullable();
            $table->string('header', 255)->nullable();
            $table->longText('message')->nullable();
            $table->string('footer', 255)->nullable();
            $table->boolean('is_default')->default(false);
            $table->string('file', 255)->nullable();
            $table->string('file_type', 255)->nullable();
            $table->string('file_size_in_bytes', 255)->nullable();
            $table->string('file_mime_type', 255)->nullable();
            $table->string('status', 255)->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('templates');
    }
}
