<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhatsappLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whatsapp_logs', function (Blueprint $table) {
            $table->id();
            $table->string('wamid');  
            $table->unsignedBigInteger('user_id')->nullable(); 
            $table->unsignedBigInteger('visitor_id')->nullable();
            $table->unsignedBigInteger('template_id')->nullable(); 
            $table->text('message');  // Text column for reply
            $table->string('mobile')->nullable(); 
            $table->string('status', 25)->nullable(); 
            $table->timestamp('created_at')->nullable(); 
            $table->timestamp('updated_at')->nullable(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whatsapp_logs');
    }
}
