<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddBulkWhatsappToPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('permissions', function (Blueprint $table) {
            // Add the 'Bulk_Whatsapp' column
            $table->enum('Bulk_Whatsapp', ['0', '1'])->default('1')->after('Export_Excel');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permissions', function (Blueprint $table) {
            // Drop the 'Bulk_Whatsapp' column if rolling back
            $table->dropColumn('Bulk_Whatsapp');
        });
    }
}
