<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhatsappRepliesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         Schema::create('whatsapp_replies', function (Blueprint $table) {
        $table->id();  // Auto-incrementing primary key
        $table->string('wamid');  // varchar(255)
        $table->unsignedBigInteger('fk_wam_id')->nullable();  // varchar(255), nullable
        $table->string('sender_mobile', 25);  // varchar(25)
        $table->text('reply');  // Text column for reply
        $table->unsignedBigInteger('visitor_id')->nullable();

        // Use `created_at` and `updated_at` with Laravel's timestamps() method
        // which sets default values and handles updates correctly.
        $table->timestamps();
      

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whatsapp_replies');
    }
}
