<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFkVisitDataIdToVisitDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('visit_data', function (Blueprint $table) {
            $table->bigInteger('fk_visit_data_id')->default(0)->after('fk_visitor_id');
            $table->string('amount', 255)->nullable()->after('fk_visit_data_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('visit_data', function (Blueprint $table) {
            $table->dropColumn('fk_visit_data_id');
            $table->dropColumn('amount');
        });
    }
}
