<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhatsappBatchTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whatsapp_batch', function (Blueprint $table) {
            $table->bigIncrements('id'); // Auto-incrementing primary key
            $table->bigInteger('user_id'); // User ID as bigint
            $table->bigInteger('template_id'); // Template ID as bigint
            $table->integer('sent_count')->default(0); // Sent count with a default value of 0
            $table->timestamps(); // Created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whatsapp_batch'); // Drop the table if the migration is rolled back
    }
}
