<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFkWhatsappBatchIdToWhatsappLogs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('whatsapp_logs', function (Blueprint $table) {
            // Add the fk_whatsapp_batch_id column
            $table->bigInteger('fk_whatsapp_batch_id')->nullable()->after('status'); // You can specify the position as needed

            // Add the foreign key constraint
            // $table->foreign('fk_whatsapp_batch_id')->references('id')->on('whatsapp_batch')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('whatsapp_logs', function (Blueprint $table) {
            // Drop the foreign key and column if rolling back the migration
            // $table->dropForeign(['fk_whatsapp_batch_id']);
            $table->dropColumn('fk_whatsapp_batch_id');
        });
    }
}
