<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddHsnCodeAndPriceToProductsTable extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            // Add the `hsn_code` column after `name`
            $table->string('hsn_code')->nullable()->after('name');

            // Add the `price` column after `hsn_code`
            $table->string('price')->nullable()->after('hsn_code');
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            // Drop the columns if rolling back
            $table->dropColumn('hsn_code');
            $table->dropColumn('price');
        });
    }
}
