<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddGstnToVisitorsTable extends Migration
{
    public function up()
    {
        Schema::table('visitors', function (Blueprint $table) {
            // Add the `gstn` column to the `visitors` table
            $table->string('gstn', 255)->nullable()->default(null)->after('address_country_code'); // Replace `some_column` with the actual column you want it to come after
        });
    }

    public function down()
    {
        Schema::table('visitors', function (Blueprint $table) {
            // Drop the `gstn` column if rolling back
            $table->dropColumn('gstn');
        });
    }
}
