<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_attendances', function (Blueprint $table) {
            $table->bigIncrements('id')->unsigned();
            $table->bigInteger('customer_id')->unsigned();
            $table->timestamp('check_in_time')->nullable();
            $table->string('checkin_lat', 255)->nullable();
            $table->string('checkin_lng', 255)->nullable();
            $table->timestamp('check_out_time')->nullable();
            $table->string('checkout_lat', 255)->nullable();
            $table->string('checkout_lng', 255)->nullable();
            $table->timestamps(0); // Use 0 to avoid microseconds in timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_attendances');
    }
}
