<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('quotation_list', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('visitorid');
            $table->integer('userid');
            $table->string('priceinusd', 255);
            $table->string('pdffile', 255);
            $table->enum('type', ['Quotation', 'PI', 'Sale'])->default('Quotation');
            $table->text('detail')->nullable();
            $table->float('amount', 10, 2)->nullable();
            $table->string('fyear', 255)->nullable();
            $table->string('serialno', 255)->nullable();
            $table->string('refno', 255)->nullable();
            $table->timestamps(); // created_at and updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('quotation_list');
    }
};