<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_locations', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->nullable();
            $table->text('lat')->nullable();  // -90.000000 to 90.000000
            $table->text('lng')->nullable();  // -180.000000 to 180.000000
            $table->text('traveld_km')->nullable();
            $table->enum('on_demand',['true','false'])->default('false');
            $table->dateTime('date_time')->default(null);
            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_locations');
    }
}
