<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyAreasTableReplaceCityIdWithCityName extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('areas', function (Blueprint $table) {
            // Drop foreign key constraint
            $table->dropForeign(['city_id']);
            // Drop city_id column
            $table->dropColumn('city_id');
            // Add city_name column with text data type
            $table->text('city_name')->after('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('areas', function (Blueprint $table) {
            // Drop city_name column
            $table->dropColumn('city_name');
            // Add back city_id column
            $table->foreignId('city_id')->after('id')->constrained('cities')->onDelete('cascade');
        });
    }
}
