$(document).ready(function(){

$(document).on('click',".ajaxModelOpenBtn",function(e) {
            e.preventDefault();
            const Url = $(this).data('url')
            const beforeAjax = $(this).data('before-ajax-call');
            const afterAjax = $(this).data('after-ajax-call');
            const btn = $(this);
	    let data = {};
            if ((Url !== undefined && Url !== null)) {
                setAjaxLoader(btn, true);
		if(window[beforeAjax] && window[beforeAjax].length > 0){
			data = window[beforeAjax](data);
		}
                $.ajax({
                    type: "POST",
                    url: Url,
		    data:data,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                            'content')
                    },
                    success: function(response) {
                        setAjaxLoader(btn, false);

                        console.log(response);
                        if (response.status) {

                            $('body').find('#ajaxModal').remove();
                            $('body').append(response.html);
                            $('body').find('#ajaxModal').modal('show');

                            if(window[afterAjax] && window[afterAjax].length > 0){
                                window[afterAjax](btn, response, data);
                            }
                        } else {
                            Swal.fire('Error!', response.message,
                                'error');
                        }
                    },
                    error: function(xhr) {
                        setAjaxLoader(btn, false);

                        var error = xhr.responseJSON;
                        if (xhr.status == 422) {
                            Object.entries(error.error).forEach(function(item, index) {
                                const [key, value] = item;
                                form.find(`.${key}-error`).html(value);
                            })
                        } else {
                            Swal.fire('Error!', error.message,
                                'error');
                        }


                    }
                });
            }
        })

        $(document).on('submit', ".ajaxModalForm", function(e) {
            e.preventDefault();
            const Url = $(this).prop('action')
            const redirect = $(this).data('redirect')
	        const beforeAjax = $(this).data('before-ajax-call');
	        const afterAjax = $(this).data('after-ajax-call');

            const form = $(this)
            const Btn = $(this).find('button[type="submit"]');
            if ((Url !== undefined && Url !== null)) {
                var form_id = form[
                    0];
                var formData = new FormData(form_id);
                // formData.append("deleteProblemIds", deleteIds);
                form.find(".common-ajax-error").html("");
                setAjaxLoader(Btn, true);
                if(window[beforeAjax] && window[beforeAjax].length > 0){
                    formData = window[beforeAjax](formData);
                }
                $.ajax({
                    type: form.prop('method'),
                    url: Url,
                    data: formData,
                    dataType: "json",
                    cache: false,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                            'content')
                    },
                    success: function(response) {
                        setAjaxLoader(Btn, false);

                        console.log(response);
                        if (response.status) {
                            if($('body').find('#ajaxModal').length > 0){
                                $('body').find('#ajaxModal').modal('hide');
                            }
                            if ($(".ajaxReloadDatatable").length > 0) {
                                $(".ajaxReloadDatatable").DataTable().ajax.reload();
                            }
                            if(window[afterAjax] && window[afterAjax].length > 0){
                                 window[afterAjax](form,Btn,response);
                            }

                            Swal.fire('Success!', response.message,
                                'success').then((result) => {
                                if (result.value) {
                                    if (redirect !==
                                        undefined &&
                                        redirect !== null) {
                                        window.location.href =
                                            redirect;
                                    }

                                }
                            });
                        } else {
                            Swal.fire('Error!', response.message,
                                'error');
                        }
                    },
                    error: function(xhr) {
                        setAjaxLoader(Btn, false);
                        var error = xhr.responseJSON;
                        // console.log(xhr.responseJSON);
                        if (xhr.status == 422) {
                            Object.entries(error.error).forEach(function(item, index) {
                                const [key, value] = item;
                                $(`.${key}-error`).html(value);
                            })
                        } else {
                            Swal.fire('Error!', error.message,
                                'error');
                        }


                    }
                });
            }
        })
});

function setAjaxLoader(btn, state) {
        var text = btn.find(".submit-text");
        var loader = btn.find(".submit-loader");
        if (state) {
            loader.show()
            btn.prop("disabled", true);
        } else {
            btn.prop("disabled", false);
            loader.hide()
        }
    }
