document.addEventListener('DOMContentLoaded', function () {
    if ('Notification' in window) {
        if (Notification.permission === "granted") {
            sendUserAssignedNotification();
        } else if (Notification.permission !== "denied") {
            Notification.requestPermission().then(function (permission) {
                if (permission === "granted") {
                    sendUserAssignedNotification();
                }
            });
        }
    }
});

function sendUserAssignedNotification() {
    // Use the Notification API to show a browser notification
    new Notification("Automatic Notification", {
        body: "This is an automatic notification from the server."
    });
}
