@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ empty($subadmin) ? 'Add Division' : 'Edit Division' }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('setting.division') }}">Division List</a></li>
                        <li class="breadcrumb-item active">{{ empty($subadmin) ? 'Add Division' : 'Edit Division' }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('division.store') }}" name="form" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="{{ empty($subadmin) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{ $subadmin->id ?? 0 }}">
                                @csrf
                                <div class="form-group">
                                    <label for="">Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Enter Division Name"
                                        value="{{ empty($subadmin) ? old('name') : $subadmin->name }}" required>
                                    @if($errors->has('name'))
                                        <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label for="">Email</label>
                                    <input type="email" name="email" class="form-control" id="" placeholder="Enter Admin Email"
                                        value="{{ empty($subadmin) ? old('email') : $subadmin->email }}" required>
                                    @if($errors->has('email'))
                                        <div class="form-text text-danger">{{ $errors->first('email') }}</div>
                                    @endif
                                </div>
                                @if(empty($subadmin))
                                    <div class="form-group">
                                        <label for="">Password</label>
                                        <input type="password" name="password" class="form-control  @error('password') is-invalid @enderror" id="password"
                                        placeholder="Enter Password" value="{{ empty($subadmin) ? old('password') : $subadmin->password }}" required 
                                        autocomplete="current-password">
                                        @if($errors->has('password'))
                                            <div class="form-text text-danger">{{ $errors->first('password') }}</div>
                                        @endif
                                    </div>
                                    <div class="form-group">
                                        <label for="">Confirm Password</label>
                                        <input type="Password" name="password_confirmation" class="form-control"
                                            placeholder="Enter Conform Password"
                                            class="form-control @error('password_confirmation') is-invalid @enderror"
                                            value="" required autocomplete="current-password">
                                    </div>
                                @endif
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >{{ empty($subadmin) ? 'Add' : 'Edit' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection