@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Division List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Division</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Division</h3>
                            <div class="card-tools">
                                <a href="{{ route('division.add') }}" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects" id="dataTable">
                                <thead>
                                    <tr>
                                        <th style="width: 0%">
                                            ID
                                        </th>
                                        <th style="width: 0%">
                                            Name
                                        </th>
                                        <th style="width: 0%">
                                            Email
                                        </th>
                                        <th style="width: 0%">
                                            Password
                                        </th>
                                        <th style="width: 0%">
                                            Action
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($admin_all as $val)
                                    <tr>
                                        <td>
                                            {{$val->id}}
                                        </td>
                                        <td>
                                            {{$val->name}}
                                        </td>
                                        <td>
                                            {{$val->email}}
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-primary" data-password="{{$val->password}}"  data-userId="{{$val->id}}" onclick="changepassword({{$val->id}});">Change Password</button>
                                        </td>
                                        <td>
                                            <form method="get" name="myform" action="{{route('division.add')}}" enctype="multipart/form-data">
                                                {{-- @if(!empty($val->id)) --}}
                                                    <input type="hidden" name="id" value="{{$val->id}}">
                                                    <button class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="left" title="Edit" style="margin-top: 0px;">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                {{-- @endif --}}
                                            </form>
                                            <a data-toggle="modal" data-target="#deletePopup" data-url="{{route('division.destroy',$val->id)}}"  data-id="{{$val->id}}" 
                                                onclick="deletePopup(this)">
                                                <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete" style="margin-left: 42px;margin-top: -60px;">
                                                    <i class="fas fa-trash" aria-hidden="true"></i>
                                                </button>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="modal fade" id="passwordChangeModal" tabindex="-1" role="dialog" aria-labelledby="passwordChangeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="passwordChangeModalLabel">Change Password</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="passwordChangeForm">
                    <div class="form-group">
                        <label for="newPassword">New Password</label>
                        <input type="password" class="form-control" id="newPassword" name="newPassword" placeholder="Enter NewPssword">
                    </div>
                    <div class="form-group">
                        <label for="confirmPassword">Confirm Password</label>
                        <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" placeholder="Enter Confirm Password">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="updatePassword()">Update Password</button>
            </div>
        </div>
    </div>
</div>
<script>
    function changepassword(userId) {
        $('#passwordChangeModal').data('userId', userId);
        $('#passwordChangeModal').modal('show');
    }

    function updatePassword() {
        const userId = $('#passwordChangeModal').data('userId');
        const newPassword = $('#newPassword').val();
        const confirmPassword = $('#confirmPassword').val();

        if (newPassword !== confirmPassword) {
            alert('Passwords do not match.');
        } else if (newPassword.length < 6) {
            alert('Password must be at least 6 characters long.');
        } else {
         
            $.ajax({
                type: 'POST',
                url: "{{ route('edit_password') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    userId:userId,
                    newPassword: newPassword,
                },
                success: function(response) {
                    $('#passwordChangeModal').modal('hide');
                    alert('Password updated successfully.');
                    location.reload(); 
                },
                error: function() {
                    alert('Error updating password.');
                },
            });
        }
    }
</script>
@endsection

