<div class="modal-header">
    <h5 class="modal-title" id="editCategoryModalLabel">Edit Category</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<div class="modal-body">
    <form action="{{ route('category.store') }}" method="POST" id="editCategoryForm">
        <input type="hidden" name="action" value="update">
        <input type="hidden" name="id" value="{{ $category->id ?? 0 }}">
        @csrf
        <div class="form-group" id="category-names-container">
            <label for="">Category Name</label>
            <input type="text" class="form-control" id="category-name-1"
                placeholder="Enter Category Name"
                name="name"
                value="{{ $category->name }}" required>

            @if($errors->has('name'))
                <div class="form-text text-danger">{{ $errors->first('name') }}</div>
            @endif
        </div>

        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Edit</button>
        </div>
    </form>
</div>

<script>
    $(document).ready(function() {
    
        $('#editCategoryForm').validate({
            rules: {
                name: {
                    required: true,
                }
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            },
            submitHandler: function(form) {
                $("#overlay").fadeIn(300);
                // alert('ajax call');
                // return;
                // console.log($('#editCategoryForm').serialize()); return false;
                $.ajax({
                    url: "{{ route('category.store') }}",
                    type: "POST",
                    data: $('#editCategoryForm').serialize(),
                    success: function(response) {
                        // console.log(response.status);
                        if (response.status) {
                            swal({
                                title: "Success!",
                                text: response.message,
                                icon: "success"
                            });
                            $('#editCategoryModal').modal('hide');
                            window.LaravelDataTables["category-table"].ajax.reload();
                        }
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    },
                    error: function(data) {
                        console.log(data);
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    }
                });
            }
        });

    });
</script>