@extends('layouts.master')
@section('content')
<style>
    .cke_button__customimageupload_icon {
        background-image: url('{{ asset('assets/images/dashboard_icons/file.png') }}');
        background-size: cover;
        width: 16px;
        height: 16px;
        border: none;
        display: inline-block;
    }
</style>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Email Draft</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('emails.index') }}">Email Draft</a></li>
                        <li class="breadcrumb-item active">Edit Email Draft</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('emails.store') }}" name="form" enctype="multipart/form-data">
                                @csrf
                                

                                {{-- <div class="form-group ml-3">
                                    <label class="form-label">Select Email Type</label>
                                    <select class="form-control col-lg-10" name="email_type" id="email_type" required>
                                        <option value="" selected disabled>Select Email Type</option>
                                        <option value="primary" {{ old('email_type', $emails->email_type) == 'primary' ? 'selected' : '' }}>Primary</option>
                                        <option value="follow_up" {{ old('email_type', $emails->email_type) == 'follow_up' ? 'selected' : '' }}>Follow Up</option>
                                        <option value="other" {{ old('email_type', $emails->email_type) == 'other' ? 'selected' : '' }}>Other</option>
                                        @foreach($actionList as $action)
                                        <option value="{{ $action->title }}" {{ old('email_type', $emails->email_type) == $action->title ? 'selected' : '' }}>{{ $action->title }}</option>
                                    @endforeach
                                    </select>
                                </div> --}}

                                <div class="form-group radio-group ml-3">
                                    <input type="radio" name="etype" id="action" class="radio-large" checked>
                                    <label style="margin-top: 6px;" for="action" class="radio-label">Action</label>
                                    <input type="radio" name="etype" id="category" class="radio-large">
                                    <label style="margin-top: 6px;" for="category" class="radio-label">Category</label>
                                </div>
                                
                                <div class="ml-3" id="actionList">
                                    <label class="form-label emailLabel">Select Email Type</label>
                                    <select class="form-control col-lg-10" name="email_action_type">
                                        <option value="" selected disabled>Select Email Type</option>
                                        {{-- <option value="primary" {{ old('email_action_type') == 'primary' ? 'selected' : '' }}>Primary</option>
                                        <option value="follow_up" {{ old('email_action_type') == 'follow_up' ? 'selected' : '' }}>Follow Up</option>
                                        <option value="other" {{ old('email_action_type') == 'other' ? 'selected' : '' }}>Other</option> --}}
                                        @foreach ($actionList as $action)
                                            <option value="{{ $action->title }}" {{ old('email_action_type') == $action->title ? 'selected' : '' }}>
                                                {{ $action->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="ml-3" id="categoryList">
                                    <label class="form-label emailLabel">Select Email Type</label>
                                    <select class="form-control col-lg-10" name="email_category_type">
                                        <option value="" selected disabled>Select Email Type</option>
                                        <option value="primary" {{ old('email_category_type') == 'primary' ? 'selected' : '' }}>Primary</option>
                                        <option value="follow_up" {{ old('email_category_type') == 'follow_up' ? 'selected' : '' }}>Follow Up</option>
                                        <option value="other" {{ old('email_category_type') == 'other' ? 'selected' : '' }}>Other</option>
                                        @foreach ($categoryList as $c => $category)
                                            <option value="{{ $category }}" {{ old('email_category_type') == $category ? 'selected' : '' }}>
                                                {{ $category }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Subject</label>
                                    <input type="text" name="subject" class="form-control col-lg-10" id="subject" value="{{ old('subject', $emails->subject) }}" placeholder="Enter Subject" required>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Content</label>
                                    <textarea class="editor" name="content" id="content" cols="30" rows="30">{{ empty($emails->content) ? $body : $emails->content   }}</textarea>
                                </div>
                                    {{-- <div class="form-group ml-3">
                                        <label class="form-label">Attachment</label>
                                        @foreach($get_image as $images)
                                            <img src="{{ asset(UPLOAD_EMAIL.$images->attachment) }}" alt="" class="img" style="height: 85px; width: 85px">
                                            <span> 
                                                <i class="fa">&#xf00d;</i>
                                            </span>
                                        @endforeach
                                    </div> --}}
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment</label>
                                            @foreach($get_image as $image)
                                                <div class="image-container" style="position: relative; display: inline-block; margin-right: 10px;">
                                                    <!-- <img src="{{ asset(UPLOAD_EMAIL . $image->attachment) }}" alt="" class="img" style="height: 85px; width: 85px"> -->
                                                    @if (pathinfo($image->attachment, PATHINFO_EXTENSION) === 'pdf')
                                                        <img src="{{ asset('pdficon.png') }}" alt="PDF Icon" class="img" style="height: 94px; width: 85px">
                                                    @else
                                                        <img src="{{ asset(UPLOAD_EMAIL . $image->attachment) }}" alt="" class="img" style="height: 85px; width: 85px">
                                                    @endif
                                                    <i style="position: absolute; top: 5px; right: 5px; font-size: 15px; color: white; cursor: pointer;" 
                                                        onclick="deletePopupfile(this)" class="fa fa-times" data-id="{{ $image->id }}" value="{{ $image->id }}" data-url="{{ route('delete', ['id' => $image->id]) }}"></i>
                                                </div>
                                            @endforeach
                                    </div>
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment Name : </label>
                                        @foreach($get_image as $image)
                                            <?php 
                                                $imageName = basename($image->attachment);     
                                            ?>
                                            {{$imageName}}@if(isset($image->attachment)) ,@endif 
                                        @endforeach
                                    </div>
                                    <div class="form-group ml-3">
                                        <input class="form-control col-lg-10" type="file" name="attachment[]" id="attachment" multiple>
                                    </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function updateVisibilityAndRequirements() {
            if ($('#action').is(':checked')) {
                $('#actionList').show();
                $('#categoryList').hide();
                $('#email_action_type').prop('required', true);
                $('#email_category_type').prop('required', false);
            } else if ($('#category').is(':checked')) {
                $('#actionList').hide();
                $('#categoryList').show();
                $('#email_action_type').prop('required', false);
                $('#email_category_type').prop('required', true);
            }
        }

        // Attach change event listener to radio buttons
        $('input[type=radio][name=etype]').change(updateVisibilityAndRequirements);

        // Initialize visibility and requirements on page load
        updateVisibilityAndRequirements();
    });
</script>
<script>
    $(document).ready(function () {
        // CKEDITOR.replace( 'content' );
        CKEDITOR.replace('content', {
        extraPlugins: 'customImageUpload',
        height: 500
    });
    });

    (function() {
    CKEDITOR.plugins.add('customImageUpload', {
        icons: 'image',
        init: function(editor) {
            // Add the command for uploading images
            editor.addCommand('uploadImage', {
                exec: function(editor) {
                    var fileInput = document.createElement('input');
                    fileInput.type = 'file';
                    fileInput.accept = 'image/*';
                    fileInput.onchange = function(event) {
                        var file = event.target.files[0];
                        var formData = new FormData();
                        formData.append('image', file);

                        $.ajax({
                            type: 'POST',
                            url: "{{ route('email-upload-image') }}",
                            data: formData,
                            cache: false,
                            contentType: false,
                            processData: false,
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function(data) {
                                if (data.status === 200 && data.url) {
                                    // Open the image dialog and set the URL field
                                    // editor.execCommand('image');
                                    // editor.once('dialogShow', function(evt) {
                                    //     var dialog = evt.data;
                                    //     if (dialog.getName() === 'image') {
                                    //         var urlField = dialog.getContentElement('info', 'url');
                                    //         if (urlField) {
                                    //             urlField.setValue(data.url);
                                    //         }
                                    //     }
                                    // });
                                    if (data.status === 200 && data.url) {                                     
                                        editor.insertHtml('<img src="' + data.url + '" alt="Image">');                                 
                                    } else {                                     
                                        alert('Image upload failed!');
                                    }
                                   
                                } else {
                                    alert('Image upload failed!');
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error('Upload failed:', error);
                                alert('Image upload failed!');
                            }
                        });
                    };
                    fileInput.click();
                }
            });

            // Add a custom button to the image dialog
            CKEDITOR.on('dialogDefinition', function(ev) {
                var dialogName = ev.data.name;
                var dialogDefinition = ev.data.definition;

                if (dialogName === 'image') {
                    var infoTab = dialogDefinition.getContents('info');
                    infoTab.elements.push({
                        type: 'button',
                        id: 'uploadImageButton',
                        label: 'Upload Image',
                        filebrowser: {
                            action: 'Upload',
                            url: '{{ route('email-upload-image') }}',
                            title: 'Upload Image'
                        },
                        onClick: function() {
                            editor.execCommand('uploadImage');
                        }
                    });
                }
            });

            // Add the custom button to the toolbar
            editor.ui.addButton('CustomImageUpload', {
                label: 'Upload Image',
                command: 'uploadImage',
                toolbar: 'insert',
                icon: 'customimageupload'  // Referencing the CSS class for your custom icon
            });
        }
    });
})();





</script>
<script>
    function deletePopupfile(elm) {
        var imageId = $(elm).attr('data-id');
        var url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
   
</script>
@endsection
